/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.api.config.IConfigCategory;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.api.config.IConfigObject;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.config.TopLevelCategory;
import vazkii.quark.base.client.config.external.ExternalConfigHandler;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.IConfigCallback;

@OnlyIn(value=Dist.CLIENT)
public final class IngameConfigHandler
implements IConfigCallback {
    public static final IngameConfigHandler INSTANCE = new IngameConfigHandler();
    public Map<String, TopLevelCategory> topLevelCategories = new LinkedHashMap<String, TopLevelCategory>();
    private IConfigCategory currCategory = null;

    private IngameConfigHandler() {
    }

    @Override
    public void push(String s, String comment) {
        IConfigCategory newCategory = null;
        if (this.currCategory == null) {
            newCategory = new TopLevelCategory(s, comment, null);
            this.topLevelCategories.put(s, (TopLevelCategory)newCategory);
        } else {
            newCategory = this.currCategory.addCategory(s, comment);
        }
        this.currCategory = newCategory;
    }

    @Override
    public void pop() {
        if (this.currCategory != null) {
            this.currCategory.close();
            this.currCategory = this.currCategory.getParent();
        }
    }

    @Override
    public <T> void addEntry(String name, T default_, Supplier<T> getter, String comment, Predicate<Object> restriction) {
        if (this.currCategory != null) {
            this.currCategory.addEntry(name, default_, getter, comment, restriction);
        }
    }

    public IConfigObject<Boolean> getCategoryEnabledObject(ModuleCategory category) {
        return this.topLevelCategories.get("categories").getModuleOption(category);
    }

    public IConfigCategory getConfigCategory(ModuleCategory category) {
        return this.topLevelCategories.get(category == null ? "general" : category.name);
    }

    public void refresh() {
        this.topLevelCategories.values().forEach(IConfigElement::refresh);
    }

    public void debug() {
        if (!Quark.DEBUG_MODE) {
            return;
        }
        IngameConfigHandler.writeToFile(new File("config", "quark-common.toml-generated"), this.topLevelCategories);
    }

    public void commit() {
        IngameConfigHandler.commit(new File("config", "quark-common.toml"), this.topLevelCategories);
        ExternalConfigHandler.instance.commit();
    }

    public static <T extends IConfigCategory> void commit(File file, Map<String, T> map) {
        for (IConfigCategory c : map.values()) {
            if (!c.isDirty()) continue;
            IngameConfigHandler.save(file, map);
            return;
        }
    }

    public static <T extends IConfigCategory> void save(File file, Map<String, T> map) {
        IngameConfigHandler.writeToFile(file, map);
        for (IConfigCategory c1 : map.values()) {
            c1.clean();
        }
    }

    public static <T extends IConfigCategory> void writeToFile(File file, Map<String, T> map) {
        try {
            file.createNewFile();
            PrintStream stream = new PrintStream(file);
            for (String name : map.keySet()) {
                ((IConfigCategory)map.get(name)).print("", stream);
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

