/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.api.config;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import vazkii.quark.api.config.IConfigElement;

@OnlyIn(value=Dist.CLIENT)
public interface IConfigCategory
extends IConfigElement {
    public IConfigCategory addCategory(String var1, @Nonnull String var2);

    public <T> IConfigElement addEntry(String var1, T var2, Supplier<T> var3, @Nonnull String var4, @Nonnull Predicate<Object> var5);

    default public <T> void addEntry(String name, T default_, Supplier<T> getter, String comment) {
        this.addEntry(name, default_, getter, comment, (Predicate<Object>)Predicates.alwaysTrue());
    }

    default public <T> void addEntry(String name, T default_, Supplier<T> getter) {
        this.addEntry(name, default_, getter, "");
    }

    default public <T> void addEntry(ForgeConfigSpec.ConfigValue<T> forgeValue) {
        this.addEntry((String)forgeValue.getPath().get(0), forgeValue.get(), () -> forgeValue.get());
    }

    default public IConfigCategory addCategory(String name) {
        return this.addCategory(name, "");
    }

    public String getPath();

    public int getDepth();

    public List<IConfigElement> getSubElements();

    public void updateDirty();

    public void close();
}

