/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.module;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.addons.oddities.entity.TotemOfHoldingEntity;
import vazkii.quark.addons.oddities.item.SoulCompassItem;
import vazkii.quark.addons.oddities.render.TotemOfHoldingRenderer;
import vazkii.quark.base.client.handler.RequiredModTooltipHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.ODDITIES, requiredMod="quarkoddities", hasSubscriptions=true)
public class TotemOfHoldingModule
extends QuarkModule {
    private static final String TAG_LAST_TOTEM = "quark:lastTotemOfHolding";
    private static final String TAG_DEATH_X = "quark:deathX";
    private static final String TAG_DEATH_Z = "quark:deathZ";
    private static final String TAG_DEATH_DIM = "quark:deathDim";
    public static EntityType<TotemOfHoldingEntity> totemType;
    public static SoulCompassItem soulCompass;
    public static final ModelResourceLocation MODEL_LOC;
    @Config(description="Set this to false to remove the behaviour where totems destroy themselves if the player dies again.")
    public static boolean darkSoulsMode;
    @Config(name="Spawn Totem on PVP Kill")
    public static boolean enableOnPK;
    @Config(description="Set this to true to make it so that if a totem is destroyed, the items it holds are destroyed alongside it rather than dropped")
    public static boolean destroyLostItems;
    @Config(description="Set this to false to only allow the owner of a totem to collect its items rather than any player")
    public static boolean allowAnyoneToCollect;
    @Config(flag="soul_compass")
    public static boolean enableSoulCompass;

    @Override
    public void construct() {
        soulCompass = new SoulCompassItem(this);
        soulCompass.setCondition(() -> enableSoulCompass);
        totemType = EntityType.Builder.func_220322_a(TotemOfHoldingEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 1.0f).setTrackingRange(64).setUpdateInterval(128).func_220320_c().setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new TotemOfHoldingEntity((EntityType<? extends TotemOfHoldingEntity>)totemType, (World)world)).func_206830_a("totem");
        RegistryHelper.register(totemType, (String)"totem");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(totemType, TotemOfHoldingRenderer::new);
        ItemModelsProperties.func_239418_a_((Item)soulCompass, (ResourceLocation)new ResourceLocation("angle"), SoulCompassItem::angle);
        RequiredModTooltipHandler.map((Item)soulCompass, "quarkoddities");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistry() {
        ModelLoader.addSpecialModel((ResourceLocation)MODEL_LOC);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        Collection drops = event.getDrops();
        if (!(event.isCanceled() || !enableOnPK && event.getSource().func_76346_g() instanceof PlayerEntity)) {
            PlayerEntity player = (PlayerEntity)entity;
            CompoundNBT data = player.getPersistentData();
            CompoundNBT persistent = data.func_74775_l("PlayerPersisted");
            if (!drops.isEmpty()) {
                TotemOfHoldingEntity totem = new TotemOfHoldingEntity(totemType, player.field_70170_p);
                totem.func_70107_b(player.func_226277_ct_(), Math.max(3.0, player.func_226278_cu_() + 1.0), player.func_226281_cx_());
                totem.setOwner(player);
                totem.func_200203_b(player.func_145748_c_());
                drops.stream().filter(Objects::nonNull).map(ItemEntity::func_92059_d).filter(stack -> !stack.func_190926_b()).forEach(totem::addItem);
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_217376_c((Entity)totem);
                }
                persistent.func_74778_a(TAG_LAST_TOTEM, totem.func_110124_au().toString());
                event.setCanceled(true);
            } else {
                persistent.func_74778_a(TAG_LAST_TOTEM, "");
            }
            BlockPos pos = player.func_233580_cy_();
            persistent.func_74768_a(TAG_DEATH_X, pos.func_177958_n());
            persistent.func_74768_a(TAG_DEATH_Z, pos.func_177952_p());
            persistent.func_74778_a(TAG_DEATH_DIM, player.field_70170_p.func_234923_W_().func_240901_a_().toString());
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_218657_a("PlayerPersisted", (INBT)persistent);
            }
        }
    }

    public static String getTotemUUID(PlayerEntity player) {
        CompoundNBT cmp = player.getPersistentData().func_74775_l("PlayerPersisted");
        if (cmp.func_74764_b(TAG_LAST_TOTEM)) {
            return cmp.func_74779_i(TAG_LAST_TOTEM);
        }
        return "";
    }

    public static Pair<BlockPos, String> getPlayerDeathPosition(Entity e) {
        CompoundNBT cmp;
        if (e instanceof PlayerEntity && (cmp = e.getPersistentData().func_74775_l("PlayerPersisted")).func_74764_b(TAG_LAST_TOTEM)) {
            int x = cmp.func_74762_e(TAG_DEATH_X);
            int z = cmp.func_74762_e(TAG_DEATH_Z);
            String dim = cmp.func_74779_i(TAG_DEATH_DIM);
            return Pair.of((Object)new BlockPos(x, -1, z), (Object)dim);
        }
        return null;
    }

    static {
        MODEL_LOC = new ModelResourceLocation(new ResourceLocation("quark", "totem_of_holding"), "inventory");
        darkSoulsMode = true;
        enableOnPK = false;
        destroyLostItems = false;
        allowAnyoneToCollect = true;
        enableSoulCompass = true;
    }
}

