/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.blay09.mods.waystones.api.GenerateWaystoneNameEvent;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.worldgen.namegen.MrPorkNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.RomanNumber;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class NameGenerator
extends WorldSavedData {
    private static final String DATA_NAME = "waystones_NameGenerator";
    private static final String USED_NAMES = "UsedNames";
    private static final NameGenerator clientStorageCopy = new NameGenerator();
    private final MrPorkNameGenerator generator = new MrPorkNameGenerator();
    private final Set<String> usedNames = Sets.newHashSet();

    private NameGenerator() {
        super(DATA_NAME);
    }

    public synchronized String getName(IWaystone waystone, Random rand) {
        String name = null;
        List customNames = (List)WaystoneConfig.COMMON.customWaystoneNames.get();
        Collections.shuffle(customNames, rand);
        for (String customName : customNames) {
            if (this.usedNames.contains(customName)) continue;
            name = customName;
            break;
        }
        if (name == null) {
            String tryName = name = this.generator.randomName(rand);
            int i = 1;
            while (this.usedNames.contains(tryName)) {
                tryName = name + " " + RomanNumber.toRoman(i);
                ++i;
            }
            name = tryName;
        }
        GenerateWaystoneNameEvent event = new GenerateWaystoneNameEvent(waystone, name);
        MinecraftForge.EVENT_BUS.post((Event)event);
        name = event.getName();
        this.usedNames.add(name);
        this.func_76185_a();
        return name;
    }

    public void func_76184_a(CompoundNBT compound) {
        ListNBT tagList = compound.func_150295_c(USED_NAMES, 8);
        for (INBT tag : tagList) {
            this.usedNames.add(tag.func_150285_a_());
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT tagList = new ListNBT();
        for (String entry : this.usedNames) {
            tagList.add((Object)StringNBT.func_229705_a_((String)entry));
        }
        compound.func_218657_a(USED_NAMES, (INBT)tagList);
        return compound;
    }

    public static NameGenerator get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
            DimensionSavedDataManager storage = overworld.func_217481_x();
            return (NameGenerator)storage.func_215752_a(NameGenerator::new, DATA_NAME);
        }
        return clientStorageCopy;
    }
}

