/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Stream;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.TopSolidOnce;

public class WaystonePlacement
extends TopSolidOnce {
    public WaystonePlacement(Codec<NoPlacementConfig> codec) {
        super(codec);
    }

    public Stream<BlockPos> getPositions(WorldDecoratingHelper world, Random random, NoPlacementConfig config, BlockPos pos) {
        if (this.isWaystoneChunk(world, pos)) {
            return super.func_241857_a(world, random, (IPlacementConfig)config, pos);
        }
        return Stream.empty();
    }

    private boolean isWaystoneChunk(WorldDecoratingHelper world, BlockPos pos) {
        int chunkDistance = (Integer)WaystoneConfig.COMMON.worldGenFrequency.get();
        if (chunkDistance == 0) {
            return false;
        }
        int maxDeviation = (int)Math.ceil((float)chunkDistance / 2.0f);
        int chunkX = pos.func_177958_n() / 16;
        int chunkZ = pos.func_177952_p() / 16;
        int devGridX = pos.func_177958_n() / 16 * maxDeviation;
        int devGridZ = pos.func_177952_p() / 16 * maxDeviation;
        long seed = world.field_242889_a.func_72905_C();
        Random random = new Random(seed * (long)devGridX * (long)devGridZ);
        int chunkOffsetX = random.nextInt(maxDeviation);
        int chunkOffsetZ = random.nextInt(maxDeviation);
        return (chunkX + chunkOffsetX) % chunkDistance == 0 && (chunkZ + chunkOffsetZ) % chunkDistance == 0;
    }
}

