/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.container.WaystoneSelectionContainer;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SelectWaystoneMessage {
    private final IWaystone waystone;

    public SelectWaystoneMessage(IWaystone waystone) {
        this.waystone = waystone;
    }

    public static void encode(SelectWaystoneMessage message, PacketBuffer buf) {
        buf.func_179252_a(message.waystone.getWaystoneUid());
    }

    public static SelectWaystoneMessage decode(PacketBuffer buf) {
        WaystoneProxy waystone = new WaystoneProxy(buf.func_179253_g());
        return new SelectWaystoneMessage(waystone);
    }

    public static void handle(SelectWaystoneMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null || !(player.field_71070_bA instanceof WaystoneSelectionContainer)) {
                return;
            }
            WaystoneSelectionContainer container = (WaystoneSelectionContainer)player.field_71070_bA;
            if (PlayerWaystoneManager.isWaystoneActivated((PlayerEntity)player, message.waystone)) {
                PlayerWaystoneManager.tryTeleportToWaystone(player, message.waystone, container.getWarpMode(), container.getWaystoneFrom());
            }
            player.func_71053_j();
        });
        context.setPacketHandled(true);
    }
}

