/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.UUID;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.api.IWaystone;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class Waystone
implements IWaystone {
    private final UUID waystoneUid;
    private final RegistryKey<World> dimension;
    private final BlockPos pos;
    private final boolean wasGenerated;
    private String name;
    private boolean isGlobal;
    private UUID ownerUid;

    public Waystone(UUID waystoneUid, RegistryKey<World> dimension, BlockPos pos, boolean wasGenerated, @Nullable UUID ownerUid) {
        this.waystoneUid = waystoneUid;
        this.dimension = dimension;
        this.pos = pos;
        this.wasGenerated = wasGenerated;
        this.ownerUid = ownerUid;
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    @Override
    public boolean wasGenerated() {
        return this.wasGenerated;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    @Override
    public boolean isOwner(PlayerEntity player) {
        return this.ownerUid == null || player.func_146103_bH().getId().equals(this.ownerUid) || player.field_71075_bZ.field_75098_d;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UUID getOwnerUid() {
        return this.ownerUid;
    }

    public static IWaystone read(PacketBuffer buf) {
        UUID waystoneUid = buf.func_179253_g();
        String name = buf.func_218666_n();
        boolean isGlobal = buf.readBoolean();
        RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(250)));
        BlockPos pos = buf.func_179259_c();
        Waystone waystone = new Waystone(waystoneUid, (RegistryKey<World>)dimension, pos, false, null);
        waystone.setName(name);
        waystone.setGlobal(isGlobal);
        return waystone;
    }

    public static void write(PacketBuffer buf, IWaystone waystone) {
        buf.func_179252_a(waystone.getWaystoneUid());
        buf.func_180714_a(waystone.getName());
        buf.writeBoolean(waystone.isGlobal());
        buf.func_192572_a(waystone.getDimension().func_240901_a_());
        buf.func_179255_a(waystone.getPos());
    }
}

