/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class WaystoneButton
extends Button {
    private static final ResourceLocation ENCHANTMENT_TABLE_GUI_TEXTURE = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private final int xpLevelCost;

    public WaystoneButton(int x, int y, IWaystone waystone, WarpMode warpMode, Button.IPressable pressable) {
        super(x, y, 200, 20, WaystoneButton.getWaystoneNameComponent(waystone), pressable);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.xpLevelCost = Math.round(PlayerWaystoneManager.getExperienceLevelCost((PlayerEntity)Objects.requireNonNull(player), waystone, warpMode));
        if (!PlayerWaystoneManager.mayTeleportToWaystone((PlayerEntity)player, waystone)) {
            this.field_230693_o_ = false;
        } else if (player.field_71068_ca < this.xpLevelCost && !player.field_71075_bZ.field_75098_d) {
            this.field_230693_o_ = false;
        }
    }

    private static ITextComponent getWaystoneNameComponent(IWaystone waystone) {
        StringTextComponent textComponent = new StringTextComponent(waystone.getName());
        if (waystone.isGlobal()) {
            textComponent.func_240699_a_(TextFormatting.YELLOW);
        }
        return textComponent;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        if (this.xpLevelCost > 0) {
            boolean canAfford = Objects.requireNonNull(mc.field_71439_g).field_71068_ca >= this.xpLevelCost || mc.field_71439_g.field_71075_bZ.field_75098_d;
            mc.func_110434_K().func_110577_a(ENCHANTMENT_TABLE_GUI_TEXTURE);
            this.func_238474_b_(matrixStack, this.field_230690_l_ + 2, this.field_230691_m_ + 2, (Math.min(this.xpLevelCost, 3) - 1) * 16, 223 + (!canAfford ? 16 : 0), 16, 16);
            if (this.xpLevelCost > 3) {
                mc.field_71466_p.func_238421_b_(matrixStack, "+", (float)(this.field_230690_l_ + 17), (float)(this.field_230691_m_ + 6), 0xC8FF8F);
            }
            if (this.field_230692_n_ && mouseX <= this.field_230690_l_ + 16) {
                ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
                TranslationTextComponent levelRequirementText = new TranslationTextComponent("gui.waystones.waystone_selection.level_requirement", new Object[]{this.xpLevelCost});
                levelRequirementText.func_240699_a_(canAfford ? TextFormatting.GREEN : TextFormatting.RED);
                tooltip.add(levelRequirementText);
                Screen screen = Minecraft.func_71410_x().field_71462_r;
                mc.field_71466_p.getClass();
                Objects.requireNonNull(screen).func_243308_b(matrixStack, tooltip, mouseX, mouseY + 9);
            }
            RenderSystem.disableLighting();
        }
    }
}

