/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.IForgeUnit;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class UnitsInit<T> {
    private final ForgeMod mod;
    protected final Set<T> units = new HashSet<T>();

    public UnitsInit(ForgeMod mod) {
        this.mod = mod;
    }

    public T add(T unit) {
        this.units.add(unit);
        return unit;
    }

    public void add(T ... units) {
        for (T unit : units) {
            this.add(unit);
        }
    }

    public Set<T> getAll() {
        return Collections.unmodifiableSet(this.units);
    }

    public ForgeMod getMod() {
        return this.mod;
    }

    public static Path getConfigsDir(ForgeMod mod, Class<?> clazz) {
        return mod.getConfigsDir().resolve(clazz.getSimpleName());
    }

    public Path getConfigsDir() {
        return UnitsInit.getConfigsDir(this.getMod(), this.getClass());
    }

    public UnitConfig createConfigFor(Class<? extends T> clazz) {
        return UnitConfig.in(this.getConfigsDir(), IForgeUnit.getClassRegName(clazz));
    }
}

