/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.math.Vect3d;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class ForgeNetMsg<MSG extends ForgeNetMsg<MSG>> {
    private static final Map<Class<?>, FieldHandler<?>> fieldHandlers = new HashMap();
    private static final Map<Class<?>, Field[]> fieldCache = new HashMap();

    public void encode(MSG msg, PacketBuffer buf) {
        ((ForgeNetMsg)msg).encodeTo(buf);
    }

    public MSG decode(PacketBuffer buf) {
        MSG msg = this.create();
        ((ForgeNetMsg)msg).decodeFrom(buf);
        return msg;
    }

    public abstract MSG create();

    public abstract void handle(World var1, PlayerEntity var2);

    public void handle(MSG msg, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            PlayerEntity player = this.getPlayer(ctx);
            if (player != null) {
                msg.handle(player.field_70170_p, player);
                ctx.setPacketHandled(true);
            }
        });
    }

    protected final void decodeFrom(PacketBuffer buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.readField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    protected final void encodeTo(PacketBuffer buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.writeField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        Field[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = clazz.getFields();
            Arrays.sort(fields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private final void writeField(Field field, PacketBuffer buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            ((INetSerializable)value).writeTo(buf);
        } else if (type.isEnum()) {
            int ordinal = ((Enum)value).ordinal();
            buf.writeInt(ordinal);
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            handler.writer.write(value, buf);
        }
    }

    private final void readField(Field field, PacketBuffer buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            value = ((INetSerializable)value).readFrom(buf);
        } else if (type.isEnum()) {
            int ordinal = buf.readInt();
            value = type.getEnumConstants()[ordinal];
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            value = handler.reader.read(buf);
        }
        field.set(this, value);
    }

    private static FieldHandler<?> getFieldHandler(Class<?> clazz) {
        FieldHandler<?> handler = fieldHandlers.get(clazz);
        if (handler == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return handler;
    }

    public static <T> void addFieldHandler(Class<T> type, IReader<T> reader, IWriter<T> writer) {
        fieldHandlers.put(type, new FieldHandler<T>(reader, writer));
    }

    private boolean acceptField(Field field) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        if (INetSerializable.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        return fieldHandlers.containsKey(type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Nullable
    public PlayerEntity getPlayer(NetworkEvent.Context ctx) {
        return this.getSide(ctx).isClient() ? this.getClientPlayer() : ctx.getSender();
    }

    public LogicalSide getSide(NetworkEvent.Context ctx) {
        return ctx.getDirection().getReceptionSide();
    }

    static {
        ForgeNetMsg.addFieldHandler(Byte.TYPE, buf -> buf.readByte(), (value, buf) -> buf.writeByte((int)value.byteValue()));
        ForgeNetMsg.addFieldHandler(Short.TYPE, buf -> buf.readShort(), (value, buf) -> buf.writeShort((int)value.shortValue()));
        ForgeNetMsg.addFieldHandler(Integer.TYPE, buf -> buf.readInt(), (value, buf) -> buf.writeInt(value.intValue()));
        ForgeNetMsg.addFieldHandler(Long.TYPE, buf -> buf.readLong(), (value, buf) -> buf.writeLong(value.longValue()));
        ForgeNetMsg.addFieldHandler(Float.TYPE, buf -> Float.valueOf(buf.readFloat()), (value, buf) -> buf.writeFloat(value.floatValue()));
        ForgeNetMsg.addFieldHandler(Double.TYPE, buf -> buf.readDouble(), (value, buf) -> buf.writeDouble(value.doubleValue()));
        ForgeNetMsg.addFieldHandler(Boolean.TYPE, buf -> buf.readBoolean(), (value, buf) -> buf.writeBoolean(value.booleanValue()));
        ForgeNetMsg.addFieldHandler(Character.TYPE, buf -> Character.valueOf(buf.readChar()), (value, buf) -> buf.writeChar((int)value.charValue()));
        ForgeNetMsg.addFieldHandler(String.class, buf -> buf.func_218666_n(), (string, buf) -> buf.func_180714_a(string));
        ForgeNetMsg.addFieldHandler(CompoundNBT.class, buf -> buf.func_150793_b(), (compound, buf) -> buf.func_150786_a(compound));
        ForgeNetMsg.addFieldHandler(ItemStack.class, buf -> buf.func_150791_c(), (stack, buf) -> buf.func_150788_a(stack));
        ForgeNetMsg.addFieldHandler(BlockPos.class, buf -> buf.func_179259_c(), (pos, buf) -> buf.func_179255_a(pos));
        ForgeNetMsg.addFieldHandler(Vect3d.class, buf -> Vect3d.readFromByteBuf((ByteBuf)buf), (vec, buf) -> Vect3d.writeToByteBuf(vec, (ByteBuf)buf));
        ForgeNetMsg.addFieldHandler(BlockState.class, buf -> Block.func_196257_b((int)buf.readInt()), (state, buf) -> buf.writeInt(Block.func_196246_j((BlockState)state)));
        ForgeNetMsg.addFieldHandler(ColorARGB.class, buf -> ColorARGB.from(buf.readInt()), (color, buf) -> buf.writeInt(color.getARGB()));
        ForgeNetMsg.addFieldHandler(Enum.class, null, (value, buf) -> buf.writeInt(value.ordinal()));
    }

    public static interface IReader<T> {
        public T read(PacketBuffer var1);
    }

    public static interface IWriter<T> {
        public void write(T var1, PacketBuffer var2);
    }

    private static class FieldHandler<T> {
        public final IReader<T> reader;
        public final IWriter<T> writer;

        public FieldHandler(IReader<T> reader, IWriter<T> writer) {
            this.reader = reader;
            this.writer = writer;
        }
    }
}

