/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LivingHealthRegen<L extends LivingEntity>
implements IHaveConfig {
    protected final GameTime updateInterval = GameTime.quaterSecond();
    private final UnitConfig config;
    private final Class<L> livingClass;
    private final CommonTime.Interval afterHurtCooldown;
    private final float healOnEachUpdate;
    protected Map<L, CommonTime.Stamp> lastHurtsMap = new HashMap<L, CommonTime.Stamp>();

    public LivingHealthRegen(ForgeMod mod, UnitConfig config, Class<L> livingClass, float cooldownInSeconds, float healOnEachUpdate) {
        this.config = config;
        this.livingClass = livingClass;
        cooldownInSeconds = UnitConfig.getFloat(config, this.getClassCategory(), "afterHurtCooldown", cooldownInSeconds, FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(360.0f)), "Defines the cooldown period of time (in seconds) after being hurt till regeneration start");
        this.afterHurtCooldown = CommonTime.Interval.seconds(cooldownInSeconds);
        this.healOnEachUpdate = UnitConfig.getFloat(config, this.getClassCategory(), "healOnEachUpdate", healOnEachUpdate, FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(5.0f)), "Defines the amount of health (in half-hearts) to be restored in each update (a quarter of second)");
        this.saveConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        CommonTime.Stamp lastHurt;
        LivingEntity living;
        World world;
        if (this.isProperLivingClass(event.getEntityLiving()) && GameWorld.isServerSide((IWorldReader)(world = (living = event.getEntityLiving()).func_130014_f_())) && ((lastHurt = this.lastHurtsMap.get(living)) == null || CommonTime.Interval.passedFrom(lastHurt).moreThan(this.afterHurtCooldown)) && this.updateInterval.pastIn(world) && LivingHealthRegen.needsHealing(living)) {
            float healAmount = this.getHealAmount(living);
            living.func_70691_i(healAmount);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (this.isProperLivingClass(living)) {
            this.lastHurtsMap.put(living, CommonTime.Stamp.now());
        }
    }

    protected boolean isProperLivingClass(LivingEntity living) {
        return this.livingClass.isAssignableFrom(living.getClass());
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public float getHealAmount(L living) {
        return this.healOnEachUpdate;
    }

    public static boolean needsHealing(LivingEntity living) {
        return living.func_110143_aJ() > 0.0f && living.func_110143_aJ() < living.func_110138_aP();
    }
}

