/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod.hooks;

import com.endertech.minecraft.forge.coremod.ForgeMethodTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.objectweb.asm.tree.MethodInsnNode;

public abstract class BlockStateChangeHook
extends ForgeMethodTransformer {
    public final MethodSignature handler = this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(Classes.WORLD, Classes.BLOCK_POS, Classes.BLOCK_STATE, Classes.BLOCK_STATE));
    private final MethodSignature target;
    private final MethodSignature targetNode;

    public BlockStateChangeHook() {
        this.target = MethodSignature.of(Classes.WORLD.name, "setBlockState", MethodDescriptor.of(Types.BOOLEAN).withParameters(Classes.BLOCK_POS.descriptor, Classes.BLOCK_STATE.descriptor, Types.INT.descriptor));
        this.targetNode = MethodSignature.of(Classes.CHUNK.name, "setBlockState", MethodDescriptor.of(Classes.BLOCK_STATE).withParameters(Classes.BLOCK_POS, Classes.BLOCK_STATE));
    }

    public static void handle(World world, BlockPos pos, BlockState oldState, BlockState newState) {
    }

    @Override
    protected void injectInstructions(InstructList instructions) {
        instructions.loadObjFrom(0, "world").loadObjFrom(1, "blockPos").loadObjFrom(6, "oldState").loadObjFrom(2, "newState").invokeStatic(this.getHandler()).insertAfter();
    }

    @Override
    protected MethodSignature getHandler() {
        return this.handler;
    }

    @Override
    protected MethodSignature getTargetMethod() {
        return this.target;
    }

    @Override
    protected boolean isProperInstruction(MethodInsnNode node) {
        return this.targetNode.complyWith(node);
    }

    @Override
    protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
        return false;
    }
}

