/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;

public class StatesOfBlock {
    protected final Set<BlockState> states;
    protected final Block block;

    public StatesOfBlock(Block block, Collection<BlockState> states) {
        this.block = block;
        this.states = new HashSet<BlockState>();
        for (BlockState state : states) {
            if (state.func_177230_c() == block) {
                this.states.add(state);
                continue;
            }
            throw new IllegalArgumentException("State " + state + " is NOT for block " + block + ". It is for block " + state.func_177230_c());
        }
    }

    public StatesOfBlock(Block block, BlockState ... states) {
        this(block, Arrays.asList(states));
    }

    public Block getBlock() {
        return this.block;
    }

    public Set<BlockState> getStates() {
        return Collections.unmodifiableSet(this.states);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatesOfBlock) {
            StatesOfBlock other = (StatesOfBlock)obj;
            return this.getBlock() == other.getBlock();
        }
        return super.equals(obj);
    }
}

