/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cavern;

import com.yungnickyoung.minecraft.bettercaves.config.cavern.ConfigFlooredCavern;
import com.yungnickyoung.minecraft.bettercaves.config.cavern.ConfigLiquidCavern;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCaverns {
    public final ConfigLiquidCavern liquidCavern;
    public final ConfigFlooredCavern flooredCavern;
    public final ForgeConfigSpec.ConfigValue<Double> cavernSpawnChance;
    public final ForgeConfigSpec.ConfigValue<String> cavernRegionSize;
    public final ForgeConfigSpec.ConfigValue<Double> customRegionSize;

    public ConfigCaverns(ForgeConfigSpec.Builder BUILDER) {
        BUILDER.comment("##########################################################################################################\n# Settings used in the generation of caverns. Caverns are spacious caves at low altitudes.\n##########################################################################################################").push("Caverns");
        this.liquidCavern = new ConfigLiquidCavern(BUILDER);
        this.flooredCavern = new ConfigFlooredCavern(BUILDER);
        this.cavernSpawnChance = BUILDER.comment(" Percent chance of caverns spawning in a given region.\n Default: caverns spawn in 25% of regions.").worldRestart().defineInRange("Cavern Spawn Chance", 25.0, 0.0, 100.0);
        this.cavernRegionSize = BUILDER.comment(" Determines how large cavern regions are. This controls the average size of caverns.\n Accepted values: Small, Medium, Large, ExtraLarge, Custom\n Default: Small (recommended).").worldRestart().define("Cavern Region Size", (Object)"Small");
        this.customRegionSize = BUILDER.comment(" Custom value for cavern region size. Only works if Cavern Region Size is set to Custom.      Smaller value = larger regions. This value is very sensitive to change.\n     Provided values:\n         Small: 0.01\n         Medium: 0.007\n         Large: 0.005\n         ExtraLarge: 0.001\n Default: 0.01").worldRestart().defineInRange("Cavern Region Size Custom Value", 0.01, 0.0, 0.05);
        BUILDER.pop();
    }
}

