/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.common.data;

import com.google.common.collect.Maps;
import hellfirepvp.observerlib.ObserverLib;
import hellfirepvp.observerlib.api.ChangeObserver;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.ObservableArea;
import hellfirepvp.observerlib.api.ObserverProvider;
import hellfirepvp.observerlib.common.change.MatchChangeSubscriber;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.SectionWorldData;
import hellfirepvp.observerlib.common.data.base.WorldSection;
import hellfirepvp.observerlib.common.registry.RegistryProviders;
import hellfirepvp.observerlib.common.util.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class StructureMatchingBuffer
extends SectionWorldData<MatcherSectionData> {
    public StructureMatchingBuffer(WorldCacheDomain.SaveKey<? extends StructureMatchingBuffer> key) {
        super(key, 4);
    }

    @Override
    public MatcherSectionData createNewSection(int sectionX, int sectionZ) {
        return new MatcherSectionData(sectionX, sectionZ);
    }

    @Override
    public void updateTick(World world) {
    }

    @Nonnull
    public <T extends ChangeObserver> MatchChangeSubscriber<T> observeArea(World world, BlockPos center, ObserverProvider provider) {
        MatchChangeSubscriber existing = (MatchChangeSubscriber)this.getSubscriber(center);
        if (existing != null) {
            if (!((ChangeObserver)existing.getObserver()).getProviderRegistryName().equals((Object)provider.getRegistryName())) {
                ObserverLib.log.warn("Trying to observe area at dim=" + world.func_234923_W_().func_240901_a_() + " " + center.toString() + " while it is already being observed by " + ((ChangeObserver)existing.getObserver()).getProviderRegistryName());
                ObserverLib.log.warn("Removing existing observer!");
                this.write(() -> this.removeSubscriber(center));
            } else {
                return existing;
            }
        }
        ChangeObserver observer = provider.provideObserver();
        MatchChangeSubscriber<ChangeObserver> subscriber = new MatchChangeSubscriber<ChangeObserver>(center, observer);
        for (ChunkPos chPos : subscriber.getObservableChunks()) {
            MatcherSectionData data = (MatcherSectionData)this.getOrCreateSection((Vector3i)chPos.func_206849_h());
            this.write(() -> data.addSubscriber(center, subscriber));
            this.markDirty(data);
        }
        observer.initialize((IWorld)world, center);
        return subscriber;
    }

    public boolean removeSubscriber(BlockPos pos) {
        MatcherSectionData data = (MatcherSectionData)this.getOrCreateSection((Vector3i)pos);
        ChangeSubscriber removed = this.write(() -> data.removeSubscriber(pos));
        if (removed != null) {
            ObservableArea area = ((ChangeObserver)removed.getObserver()).getObservableArea();
            for (ChunkPos chPos : area.getAffectedChunks((Vector3i)pos)) {
                MatcherSectionData matchData = (MatcherSectionData)this.getOrCreateSection((Vector3i)chPos.func_206849_h());
                this.write(() -> matchData.removeSubscriber(pos));
                this.markDirty(matchData);
            }
        }
        return removed != null;
    }

    @Nullable
    public ChangeSubscriber<? extends ChangeObserver> getSubscriber(BlockPos pos) {
        return this.write(() -> ((MatcherSectionData)this.getOrCreateSection((Vector3i)pos)).getSubscriber(pos));
    }

    @Nonnull
    public Collection<MatchChangeSubscriber<?>> getSubscribers(ChunkPos pos) {
        MatcherSectionData data = (MatcherSectionData)this.getOrCreateSection((Vector3i)pos.func_206849_h());
        return this.read(() -> new ArrayList(data.requestSubscribers.values()));
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
    }

    public static class MatcherSectionData
    extends WorldSection {
        private final Map<BlockPos, MatchChangeSubscriber<? extends ChangeObserver>> requestSubscribers = Maps.newHashMap();

        private MatcherSectionData(int sX, int sZ) {
            super(sX, sZ);
        }

        @Nullable
        private MatchChangeSubscriber<? extends ChangeObserver> getSubscriber(BlockPos pos) {
            return this.requestSubscribers.get(pos);
        }

        @Nullable
        private ChangeSubscriber<? extends ChangeObserver> removeSubscriber(BlockPos pos) {
            return this.requestSubscribers.remove(pos);
        }

        @Nullable
        private ChangeSubscriber<? extends ChangeObserver> addSubscriber(BlockPos pos, MatchChangeSubscriber<? extends ChangeObserver> subscriber) {
            return this.requestSubscribers.put(pos, subscriber);
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            ListNBT subscriberList = new ListNBT();
            for (MatchChangeSubscriber<? extends ChangeObserver> sub : this.requestSubscribers.values()) {
                CompoundNBT subscriber = new CompoundNBT();
                NBTHelper.writeBlockPosToNBT(sub.getCenter(), subscriber);
                subscriber.func_74778_a("identifier", sub.getObserver().getProviderRegistryName().toString());
                NBTHelper.setAsSubTag(subscriber, "matchData", sub::writeToNBT);
                subscriberList.add((Object)subscriber);
            }
            tag.func_218657_a("subscribers", (INBT)subscriberList);
        }

        @Override
        public void readFromNBT(CompoundNBT tag) {
            this.requestSubscribers.clear();
            ListNBT subscriberList = tag.func_150295_c("subscribers", 10);
            for (int i = 0; i < subscriberList.size(); ++i) {
                CompoundNBT subscriberTag = subscriberList.func_150305_b(i);
                BlockPos requester = NBTHelper.readBlockPosFromNBT(subscriberTag);
                ResourceLocation matchIdentifier = new ResourceLocation(subscriberTag.func_74779_i("identifier"));
                ObserverProvider observer = RegistryProviders.getProvider(matchIdentifier);
                if (observer == null) {
                    ObserverLib.log.warn("Unknown Observer Provider: " + matchIdentifier.toString() + "! Skipping...");
                    continue;
                }
                MatchChangeSubscriber<ChangeObserver> subscriber = new MatchChangeSubscriber<ChangeObserver>(requester, observer.provideObserver());
                subscriber.readFromNBT(subscriberTag.func_74775_l("matchData"));
                this.requestSubscribers.put(subscriber.getCenter(), subscriber);
            }
        }
    }
}

