/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.observerlib.client.util;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class BufferDecoratorBuilder {
    private PositionDecorator positionDecorator;
    private ColorDecorator colorDecorator;
    private UVDecorator uvDecorator;
    private IntMapDecorator overlayDecorator;
    private IntMapDecorator lightmapDecorator;
    private NormalDecorator normalDecorator;

    public static BufferDecoratorBuilder withPosition(PositionDecorator positionDecorator) {
        return new BufferDecoratorBuilder().setPositionDecorator(positionDecorator);
    }

    public BufferDecoratorBuilder setPositionDecorator(PositionDecorator positionDecorator) {
        this.positionDecorator = positionDecorator;
        return this;
    }

    public static BufferDecoratorBuilder withColor(ColorDecorator colorDecorator) {
        return new BufferDecoratorBuilder().setColorDecorator(colorDecorator);
    }

    public BufferDecoratorBuilder setColorDecorator(ColorDecorator colorDecorator) {
        this.colorDecorator = colorDecorator;
        return this;
    }

    public static BufferDecoratorBuilder withUV(UVDecorator uvDecorator) {
        return new BufferDecoratorBuilder().setUvDecorator(uvDecorator);
    }

    public BufferDecoratorBuilder setUvDecorator(UVDecorator uvDecorator) {
        this.uvDecorator = uvDecorator;
        return this;
    }

    public static BufferDecoratorBuilder withOverly(IntMapDecorator overlayDecorator) {
        return new BufferDecoratorBuilder().setOverlayDecorator(overlayDecorator);
    }

    public BufferDecoratorBuilder setOverlayDecorator(IntMapDecorator overlayDecorator) {
        this.overlayDecorator = overlayDecorator;
        return this;
    }

    public static BufferDecoratorBuilder withLightmap(IntMapDecorator lightmapDecorator) {
        return new BufferDecoratorBuilder().setLightmapDecorator(lightmapDecorator);
    }

    public BufferDecoratorBuilder setLightmapDecorator(IntMapDecorator lightmapDecorator) {
        this.lightmapDecorator = lightmapDecorator;
        return this;
    }

    public static BufferDecoratorBuilder withNormal(NormalDecorator normalDecorator) {
        return new BufferDecoratorBuilder().setNormalDecorator(normalDecorator);
    }

    public BufferDecoratorBuilder setNormalDecorator(NormalDecorator normalDecorator) {
        this.normalDecorator = normalDecorator;
        return this;
    }

    public void decorate(IVertexBuilder builder, Consumer<IVertexBuilder> runDecorated) {
        runDecorated.accept(new DecoratedBuilder(builder, this));
    }

    public void decorate(IVertexConsumer consumer, Consumer<IVertexConsumer> runDecorated) {
        runDecorated.accept(new DecoratedConsumer(consumer, this));
    }

    public void decorate(BufferBuilder buf, Consumer<BufferBuilder> runDecorated) {
        runDecorated.accept(new DecoratedBufferBuilder(buf, this));
    }

    public IVertexBuilder decorate(IVertexBuilder builder) {
        return new DecoratedBuilder(builder, this);
    }

    public IVertexConsumer decorate(IVertexConsumer builder) {
        return new DecoratedConsumer(builder, this);
    }

    public BufferBuilder decorate(BufferBuilder builder) {
        return new DecoratedBufferBuilder(builder, this);
    }

    public static interface ColorDecorator {
        public int[] decorate(int var1, int var2, int var3, int var4);
    }

    public static interface UVDecorator {
        public float[] decorate(float var1, float var2);
    }

    public static interface IntMapDecorator {
        public int[] decorate(int var1, int var2);
    }

    public static interface NormalDecorator {
        public float[] decorate(float var1, float var2, float var3);
    }

    public static interface PositionDecorator {
        public double[] decorate(double var1, double var3, double var5);
    }

    private static class DecoratedBufferBuilder
    extends BufferBuilder {
        private BufferBuilder decorated;
        private BufferDecoratorBuilder decorator;
        private DecoratedConsumer decoratedDelegate;

        public DecoratedBufferBuilder(BufferBuilder decorated, BufferDecoratorBuilder decorator) {
            super(0);
            this.decorated = decorated;
            this.decoratedDelegate = new DecoratedConsumer((IVertexConsumer)this.decorated, decorator);
            this.decorator = decorator;
        }

        public void func_181674_a(float cameraX, float cameraY, float cameraZ) {
            this.decorated.func_181674_a(cameraX, cameraY, cameraZ);
        }

        public BufferBuilder.State func_181672_a() {
            return this.decorated.func_181672_a();
        }

        public void func_181668_a(int glMode, VertexFormat format) {
            this.decorated.func_181668_a(glMode, format);
        }

        public void func_178977_d() {
            this.decorated.func_178977_d();
        }

        public boolean func_227834_j_() {
            return this.decorated.func_227834_j_();
        }

        public Pair<BufferBuilder.DrawState, ByteBuffer> func_227832_f_() {
            return this.decorated.func_227832_f_();
        }

        public void func_178965_a() {
            this.decorated.func_178965_a();
        }

        public void func_227833_h_() {
            this.decorated.func_227833_h_();
        }

        public void func_178993_a(BufferBuilder.State state) {
            this.decorated.func_178993_a(state);
        }

        public void func_181675_d() {
            this.decorated.func_181675_d();
        }

        public void putBulkData(ByteBuffer buffer) {
            this.decorated.putBulkData(buffer);
        }

        public VertexFormat getVertexFormat() {
            return super.getVertexFormat();
        }

        public void func_225588_a_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
            if (this.decorator.positionDecorator != null) {
                double[] newPosition = this.decorator.positionDecorator.decorate(x, y, z);
                x = (float)newPosition[0];
                y = (float)newPosition[1];
                z = (float)newPosition[2];
            }
            if (this.decorator.colorDecorator != null) {
                int[] newColors = this.decorator.colorDecorator.decorate((int)red * 255, (int)green * 255, (int)blue * 255, (int)alpha * 255);
                red = (float)newColors[0] / 255.0f;
                green = (float)newColors[1] / 255.0f;
                blue = (float)newColors[2] / 255.0f;
                alpha = (float)newColors[3] / 255.0f;
            }
            if (this.decorator.uvDecorator != null) {
                float[] newUV = this.decorator.uvDecorator.decorate(texU, texV);
                texU = newUV[0];
                texV = newUV[1];
            }
            if (this.decorator.overlayDecorator != null) {
                int[] newOverlayCoords = this.decorator.overlayDecorator.decorate(overlayUV & 0xFFFF, overlayUV >> 16 & 0xFFFF);
                overlayUV = newOverlayCoords[0] | newOverlayCoords[1] << 16;
            }
            if (this.decorator.lightmapDecorator != null) {
                int[] newLightMapCoords = this.decorator.lightmapDecorator.decorate(lightmapUV & 0xFFFF, lightmapUV >> 16 & 0xFFFF);
                lightmapUV = newLightMapCoords[0] | newLightMapCoords[1] << 16;
            }
            if (this.decorator.normalDecorator != null) {
                float[] newNormals = this.decorator.normalDecorator.decorate(normalX, normalY, normalZ);
                normalX = newNormals[0];
                normalY = newNormals[1];
                normalZ = newNormals[2];
            }
            super.func_225588_a_(x, y, z, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }

        public VertexFormatElement func_225592_i_() {
            return this.decoratedDelegate.func_225592_i_();
        }

        public void func_181667_k() {
            this.decoratedDelegate.func_181667_k();
        }

        public void func_225589_a_(int i, byte b) {
            this.decoratedDelegate.func_225589_a_(i, b);
        }

        public void func_225590_a_(int i, float f) {
            this.decoratedDelegate.func_225590_a_(i, f);
        }

        public void func_225591_a_(int i, short s) {
            this.decoratedDelegate.func_225591_a_(i, s);
        }

        public void func_225611_b_(int red, int green, int blue, int alpha) {
            this.decorated.func_225611_b_(red, green, blue, alpha);
        }

        public IVertexBuilder func_225582_a_(double x, double y, double z) {
            return this.decoratedDelegate.func_225582_a_(x, y, z);
        }

        public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
            return this.decoratedDelegate.func_225586_a_(red, green, blue, alpha);
        }

        public IVertexBuilder func_225583_a_(float u, float v) {
            return this.decoratedDelegate.func_225583_a_(u, v);
        }

        public IVertexBuilder func_225585_a_(int u, int v) {
            return this.decoratedDelegate.func_225585_a_(u, v);
        }

        public IVertexBuilder func_225587_b_(int u, int v) {
            return this.decoratedDelegate.func_225587_b_(u, v);
        }

        public IVertexBuilder func_225584_a_(float x, float y, float z) {
            return this.decoratedDelegate.func_225584_a_(x, y, z);
        }
    }

    private static class DecoratedConsumer
    extends DecoratedBuilder
    implements IVertexConsumer {
        final IVertexConsumer vertexConsumer;

        private DecoratedConsumer(IVertexConsumer vertexConsumer, BufferDecoratorBuilder decorator) {
            super((IVertexBuilder)vertexConsumer, decorator);
            this.vertexConsumer = vertexConsumer;
        }

        public VertexFormatElement func_225592_i_() {
            return this.vertexConsumer.func_225592_i_();
        }

        public void func_181667_k() {
            this.vertexConsumer.func_181667_k();
        }

        public void func_225589_a_(int i, byte b) {
            this.vertexConsumer.func_225589_a_(i, b);
        }

        public void func_225591_a_(int i, short s) {
            this.vertexConsumer.func_225591_a_(i, s);
        }

        public void func_225590_a_(int i, float f) {
            this.vertexConsumer.func_225590_a_(i, f);
        }
    }

    private static class DecoratedBuilder
    implements IVertexBuilder {
        final IVertexBuilder vertexBuilder;
        final BufferDecoratorBuilder decorator;

        private DecoratedBuilder(IVertexBuilder vertexBuilder, BufferDecoratorBuilder decorator) {
            this.vertexBuilder = vertexBuilder;
            this.decorator = decorator;
        }

        public IVertexBuilder func_225582_a_(double x, double y, double z) {
            if (this.decorator.positionDecorator != null) {
                double[] newPosition = this.decorator.positionDecorator.decorate(x, y, z);
                this.vertexBuilder.func_225582_a_(newPosition[0], newPosition[1], newPosition[2]);
                return this;
            }
            this.vertexBuilder.func_225582_a_(x, y, z);
            return this;
        }

        public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
            if (this.decorator.colorDecorator != null) {
                int[] newColor = this.decorator.colorDecorator.decorate(red, green, blue, alpha);
                this.vertexBuilder.func_225586_a_(newColor[0], newColor[1], newColor[2], newColor[3]);
                return this;
            }
            this.vertexBuilder.func_225586_a_(red, green, blue, alpha);
            return this;
        }

        public IVertexBuilder func_225583_a_(float u, float v) {
            if (this.decorator.uvDecorator != null) {
                float[] newUV = this.decorator.uvDecorator.decorate(u, v);
                this.vertexBuilder.func_225583_a_(newUV[0], newUV[1]);
                return this;
            }
            this.vertexBuilder.func_225583_a_(u, v);
            return this;
        }

        public IVertexBuilder func_225585_a_(int u, int v) {
            if (this.decorator.overlayDecorator != null) {
                int[] newUV = this.decorator.overlayDecorator.decorate(u, v);
                this.vertexBuilder.func_225585_a_(newUV[0], newUV[1]);
                return this;
            }
            this.vertexBuilder.func_225585_a_(u, v);
            return this;
        }

        public IVertexBuilder func_225587_b_(int u, int v) {
            if (this.decorator.lightmapDecorator != null) {
                int[] newUV = this.decorator.lightmapDecorator.decorate(u, v);
                this.vertexBuilder.func_225587_b_(newUV[0], newUV[1]);
                return this;
            }
            this.vertexBuilder.func_225587_b_(u, v);
            return this;
        }

        public IVertexBuilder func_225584_a_(float x, float y, float z) {
            if (this.decorator.normalDecorator != null) {
                float[] newNormals = this.decorator.normalDecorator.decorate(x, y, z);
                this.vertexBuilder.func_225584_a_(newNormals[0], newNormals[1], newNormals[2]);
                return this;
            }
            this.vertexBuilder.func_225584_a_(x, y, z);
            return this;
        }

        public void func_181675_d() {
            this.vertexBuilder.func_181675_d();
        }
    }
}

