/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.StateContainer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.IReplacementBlock;

public class PlaceboUtil {
    @SafeVarargs
    public static <T> List<T> asList(T ... objs) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : objs) {
            list.add(t);
        }
        return list;
    }

    public static CompoundNBT getStackNBT(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static ItemStack[] toStackArray(Object ... args) {
        ItemStack[] out = new ItemStack[args.length];
        for (int i = 0; i < args.length; ++i) {
            out[i] = RecipeHelper.makeStack(args[i]);
        }
        return out;
    }

    @Deprecated
    public static void registerOverrideBlock(Block b, final String modid) {
        Block old = (Block)ForgeRegistries.BLOCKS.getValue(b.getRegistryName());
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)b);
        ForgeRegistries.ITEMS.register(new BlockItem(b, new Item.Properties().func_200916_a(old.func_199767_j().func_77640_w())){

            public String getCreatorModId(ItemStack itemStack) {
                return modid;
            }
        }.setRegistryName(b.getRegistryName()));
    }

    public static <B extends Block> void registerOverride(B block, final String modid) {
        Block old = (Block)ForgeRegistries.BLOCKS.getValue(block.getRegistryName());
        ForgeRegistries.BLOCKS.register(block);
        ForgeRegistries.ITEMS.register(new BlockItem(block, new Item.Properties().func_200916_a(old.func_199767_j().func_77640_w())){

            public String getCreatorModId(ItemStack itemStack) {
                return modid;
            }
        }.setRegistryName(block.getRegistryName()));
        PlaceboUtil.overrideStates(old, block);
    }

    public static <B extends Block> void overrideStates(Block old, B block) {
        ((IReplacementBlock)block).setStateContainer((StateContainer<Block, BlockState>)old.func_176194_O());
        ((IReplacementBlock)block)._setDefaultState(old.func_176223_P());
        block.func_176194_O().func_177619_a().forEach(b -> {
            b.field_235892_c_ = block;
            Object cfr_ignored_0 = b.field_235892_c_;
        });
        block.func_176194_O().field_177627_c = block;
    }

    public static <T> List<T> toMutable(List<T> list) {
        if (list instanceof ImmutableList) {
            list = new ArrayList<T>(list);
        }
        return list;
    }
}

