/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.config.EditModeConfig;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IngredientFilterConfig;
import mezz.jei.config.JEIClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ModIdFormattingConfig;
import mezz.jei.config.WorldConfig;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.events.EventBusHelper;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.gui.textures.Textures;
import mezz.jei.ingredients.ForgeModIdHelper;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientSorter;
import mezz.jei.startup.JeiReloadListener;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.NetworkHandler;
import mezz.jei.util.AnnotatedInstanceUtil;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientLifecycleHandler {
    final Logger LOGGER = LogManager.getLogger();
    final JeiStarter starter = new JeiStarter();
    final Textures textures;
    final IClientConfig clientConfig;
    final BookmarkConfig bookmarkConfig;
    final ModIdFormattingConfig modIdFormattingConfig;
    final IngredientFilterConfig ingredientFilterConfig;
    final WorldConfig worldConfig;
    final IModIdHelper modIdHelper;
    final IEditModeConfig editModeConfig;
    final RecipeCategorySortingConfig recipeCategorySortingConfig;
    final IIngredientSorter ingredientSorter;

    public ClientLifecycleHandler(NetworkHandler networkHandler, Textures textures) {
        File jeiConfigurationDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "jei");
        if (!jeiConfigurationDir.exists()) {
            try {
                if (!jeiConfigurationDir.mkdir()) {
                    throw new RuntimeException("Could not create config directory " + jeiConfigurationDir);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Could not create config directory " + jeiConfigurationDir, e);
            }
        }
        this.clientConfig = JEIClientConfig.clientConfig;
        this.ingredientFilterConfig = JEIClientConfig.filterConfig;
        this.modIdFormattingConfig = JEIClientConfig.modNameFormat;
        this.modIdHelper = new ForgeModIdHelper(this.clientConfig, this.modIdFormattingConfig);
        this.bookmarkConfig = new BookmarkConfig(jeiConfigurationDir);
        this.worldConfig = new WorldConfig(jeiConfigurationDir);
        this.editModeConfig = new EditModeConfig(jeiConfigurationDir);
        this.recipeCategorySortingConfig = new RecipeCategorySortingConfig(new File(jeiConfigurationDir, "recipe-category-sort-order.ini"));
        ModNameSortingConfig ingredientModNameSortingConfig = new ModNameSortingConfig(new File(jeiConfigurationDir, "ingredient-list-mod-sort-order.ini"));
        IngredientTypeSortingConfig ingredientTypeSortingConfig = new IngredientTypeSortingConfig(new File(jeiConfigurationDir, "ingredient-list-type-sort-order.ini"));
        this.ingredientSorter = new IngredientSorter(this.clientConfig, ingredientModNameSortingConfig, ingredientTypeSortingConfig);
        ErrorUtil.setModIdHelper(this.modIdHelper);
        ErrorUtil.setWorldConfig(this.worldConfig);
        KeyBindings.init();
        EventBusHelper.addListener(this, WorldEvent.Save.class, event -> this.worldConfig.onWorldSave());
        EventBusHelper.addListener(this, RecipesUpdatedEvent.class, event -> {
            ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
            if (connection != null) {
                NetworkManager networkManager = connection.func_147298_b();
                this.worldConfig.syncWorldConfig(networkManager);
            }
            this.onRecipesLoaded();
            EventBusHelper.post(new PlayerJoinedWorldEvent());
        });
        networkHandler.createClientPacketHandler(this.worldConfig);
        this.textures = textures;
    }

    private void onRecipesLoaded() {
        this.modIdFormattingConfig.checkForModNameFormatOverride();
        List<IModPlugin> plugins = AnnotatedInstanceUtil.getModPlugins();
        Minecraft minecraft = Minecraft.func_71410_x();
        if (Internal.getReloadListener() == null) {
            IResourceManager resourceManager = minecraft.func_195551_G();
            if (resourceManager instanceof IReloadableResourceManager) {
                IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)resourceManager;
                JeiReloadListener reloadListener = new JeiReloadListener(this, plugins);
                Internal.setReloadListener(reloadListener);
                reloadableResourceManager.func_219534_a((IFutureReloadListener)reloadListener);
            }
        } else {
            Internal.getReloadListener().update(this, plugins);
        }
        if (minecraft.field_71441_e != null) {
            Preconditions.checkNotNull((Object)this.textures);
            this.starter.start(plugins, this.textures, this.clientConfig, this.editModeConfig, this.ingredientFilterConfig, this.worldConfig, this.bookmarkConfig, this.modIdHelper, this.recipeCategorySortingConfig, this.ingredientSorter);
        }
    }
}

