/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.mods.adlods.Commands;
import com.endertech.minecraft.mods.adlods.ore.Deposit;
import com.endertech.minecraft.mods.adlods.ore.DepositGenerator;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaController;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adlods")
public class AdLods
extends ForgeMod {
    public static final String ID = "adlods";
    public static final String NAME = "Large Ore Deposits";
    private static AdLods instance;
    private final DepositGenerator generator;
    private final VanillaController controller;

    public AdLods() {
        instance = this;
        this.generator = new DepositGenerator(this);
        this.controller = new VanillaController(this);
    }

    public static AdLods getInstance() {
        return instance;
    }

    public static DepositGenerator getGenerator() {
        return AdLods.getInstance().generator;
    }

    public static VanillaController getController() {
        return AdLods.getInstance().controller;
    }

    public String getId() {
        return ID;
    }

    public ForgeMod.RequiredSide getRequiredSide() {
        return ForgeMod.RequiredSide.SERVER;
    }

    public void commonInit() {
    }

    public void commonPostInit() {
    }

    public void commonConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    public void clientConfigInit(ForgeMod.ConfigValueBuilder value) {
    }

    public void updateReloadedTags() {
        this.generator.loadDeposits();
        this.controller.loadOres();
    }

    protected void serverStopped(MinecraftServer server) {
        this.controller.unloadOres();
    }

    public void registerCommands(ServerCommand command) {
        String deposit = "deposit";
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list").executes(Commands::listDeposits, "deposits").executes(Commands::listGenerated, "generated");
        command.task("add").executes(context -> Commands.addDeposit(context, false), new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS)});
        command.task("addspec").executes(context -> Commands.addDeposit(context, true), new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS), ServerCommand.Arg.string((String)"oreId (in quotes)")});
        command.task("remove").executes(Commands::removeDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit")});
        command.task("gen").executes(Commands::generateDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit")}).executes(Commands::generateDepositAtChunk, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"chunkX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"chunkZ", (IntBounds)IntBounds.INTEGER)});
        command.task("genat").executes(Commands::generateDepositAtPos, new ServerCommand.Arg[]{ServerCommand.Arg.integer((String)"posX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"posZ", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.string((String)"deposit")});
        command.task("test").executes(Commands::testDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"amount", (IntBounds)Deposit.Size.BOUNDS)});
        command.task("reload").executes(Commands::reloadConfigs, new ServerCommand.Arg[0]);
        command.task("strip").executes(Commands::stripChunk, "chunk").executes(Commands::stripChunksAround, "around");
        command.task("dress").executes(Commands::dressChunk, "chunk").executes(Commands::dressChunksAround, "around").executes(Commands::dressAllChunks, "all");
        command.register();
    }

    public void registerBlocks() {
    }

    public void registerItems() {
    }

    public void registerEntities() {
    }

    public void registerTiles() {
    }
}

