/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.block.BlockEnderStorage;
import codechicken.enderstorage.misc.EnderKnobSlot;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class BlockEnderChest
extends BlockEnderStorage {
    private static final IndexedVoxelShape CHEST = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)new Cuboid6(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375)), (Object)0);
    private static final IndexedVoxelShape[][] BUTTONS = new IndexedVoxelShape[4][3];
    private static final IndexedVoxelShape[] LATCH = new IndexedVoxelShape[4];
    private static final VoxelShape[][] SHAPES = new VoxelShape[4][2];
    public static final Transformation[] buttonT = new Transformation[3];

    public BlockEnderChest(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        IndexedVoxelShape shape = CHEST;
        TileEntity t = worldIn.func_175625_s(pos);
        if (t instanceof TileEnderChest) {
            TileEnderChest tile = (TileEnderChest)t;
            shape = SHAPES[tile.rotation][tile.getRadianLidAngle(0.0f) >= 0.0 ? 0 : 1];
        }
        return shape;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEnderChest();
    }

    static {
        for (int button = 0; button < 3; ++button) {
            BlockEnderChest.buttonT[button] = new Translation(-0.1875 + 0.1875 * (double)button, 0.875, 0.0);
        }
        for (int rot = 0; rot < 4; ++rot) {
            for (int button = 0; button < 3; ++button) {
                Cuboid6 cuboid = TileFrequencyOwner.selection_button.copy();
                cuboid.apply((Transformation)new Translation(0.5, 0.0, 0.5));
                cuboid.apply(buttonT[button]);
                cuboid.apply(new Rotation((double)(-90 * rot) * 0.017453292519943, Vector3.Y_POS).at(new Vector3(0.5, 0.0, 0.5)));
                BlockEnderChest.BUTTONS[rot][button] = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)cuboid), (Object)(button + 1));
            }
            BlockEnderChest.LATCH[rot] = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)new Cuboid6(new EnderKnobSlot(rot).getSelectionBB())), (Object)4);
            for (int state = 0; state < 2; ++state) {
                ImmutableSet.Builder cuboids = ImmutableSet.builder();
                cuboids.add((Object)CHEST);
                if (state == 0) {
                    cuboids.add(BUTTONS[rot]);
                    cuboids.add((Object)LATCH[rot]);
                }
                BlockEnderChest.SHAPES[rot][state] = new MultiIndexedVoxelShape((VoxelShape)CHEST, cuboids.build());
            }
        }
    }
}

