/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.world.gen;

import enemeez.simplefarming.config.EnableConfig;
import enemeez.simplefarming.init.ModWorldGen;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class SimpleGeneration {
    private static ConfiguredFeature<?, ?> BERRY_BUSH_FEATURE = (ConfiguredFeature)ModWorldGen.BERRY_BUSH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)Features.Placements.field_243994_e.func_242728_a()).func_242731_b(100);
    private static ConfiguredFeature<?, ?> FRUIT_TREE_FEATURE = (ConfiguredFeature)ModWorldGen.FRUIT_TREE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)Features.Placements.field_243994_e.func_242728_a()).func_242731_b(100);
    private static ConfiguredFeature<?, ?> WILD_CROP_FEATURE = (ConfiguredFeature)ModWorldGen.WILD_CROP.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)Features.Placements.field_243994_e.func_242728_a()).func_242731_b(100);
    private static ConfiguredFeature<?, ?> CACTUS_CROP_FEATURE = (ConfiguredFeature)ModWorldGen.CACTUS_CROP.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)Features.Placements.field_243994_e.func_242728_a()).func_242731_b(100);
    private static ConfiguredFeature<?, ?> WILD_PLANT_FEATURE = (ConfiguredFeature)ModWorldGen.WILD_PLANT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)Features.Placements.field_243994_e.func_242728_a()).func_242731_b(100);

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (SimpleGeneration.isValidBiome(event.getCategory())) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            if (((Boolean)EnableConfig.bush_validate.get()).booleanValue()) {
                SimpleGeneration.addFeature(generation, BERRY_BUSH_FEATURE);
            }
            if (((Boolean)EnableConfig.tree_validate.get()).booleanValue()) {
                SimpleGeneration.addFeature(generation, FRUIT_TREE_FEATURE);
            }
            if (((Boolean)EnableConfig.wild_crop_validate.get()).booleanValue()) {
                SimpleGeneration.addFeature(generation, WILD_CROP_FEATURE);
            }
            if (((Boolean)EnableConfig.cactus_validate.get()).booleanValue() && event.getCategory() == Biome.Category.DESERT) {
                SimpleGeneration.addFeature(generation, CACTUS_CROP_FEATURE);
            }
            if (((Boolean)EnableConfig.wild_plant_validate.get()).booleanValue()) {
                SimpleGeneration.addFeature(generation, WILD_PLANT_FEATURE);
            }
        }
    }

    private static boolean isValidBiome(Biome.Category category) {
        return category != Biome.Category.THEEND & category != Biome.Category.NETHER;
    }

    private static void addFeature(BiomeGenerationSettingsBuilder generation, @Nullable ConfiguredFeature<?, ?> feature) {
        if (feature != null) {
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature);
        }
    }

    public static void configureFeature() {
        Registry registry = WorldGenRegistries.field_243653_e;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("simplefarming", "berry_bush"), BERRY_BUSH_FEATURE);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("simplefarming", "fruit_tree"), FRUIT_TREE_FEATURE);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("simplefarming", "wild_crop"), WILD_CROP_FEATURE);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("simplefarming", "wild_plant"), WILD_PLANT_FEATURE);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("simplefarming", "cactus_crop"), CACTUS_CROP_FEATURE);
    }
}

