/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.block.growable;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public abstract class GrowableBushBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;

    protected GrowableBushBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public BlockState withMaxAge() {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge()));
    }

    public boolean isMaxAge(BlockState state) {
        return ((Integer)state.func_177229_b((Property)this.getAgeProperty())).intValue() == this.getMaxAge();
    }

    public int getMaxAge() {
        return 3;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int age = (Integer)state.func_177229_b((Property)this.getAgeProperty());
        if (age < this.getMaxAge() && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.getAgeProperty()});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) < this.getMaxAge();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int newAge = Math.min(this.getMaxAge(), (Integer)state.func_177229_b((Property)this.getAgeProperty()) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(newAge)), 2);
    }
}

