/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.block;

import enemeez.simplefarming.init.ModRecipes;
import enemeez.simplefarming.tileentity.BrewingBarrelTileEntity;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BrewingBarrelBlock
extends ContainerBlock {
    public static final IntegerProperty PROGRESS = IntegerProperty.func_177719_a((String)"progress", (int)0, (int)3);
    public static final IntegerProperty LAYERS = IntegerProperty.func_177719_a((String)"layers", (int)0, (int)1);
    protected static final VoxelShape BOTTOM = Block.func_208617_a((double)16.0, (double)1.0, (double)16.0, (double)0.0, (double)0.0, (double)0.0);
    protected static final VoxelShape SIDE1 = Block.func_208617_a((double)16.0, (double)16.0, (double)1.0, (double)0.0, (double)0.0, (double)0.0);
    protected static final VoxelShape SIDE2 = Block.func_208617_a((double)1.0, (double)16.0, (double)16.0, (double)0.0, (double)0.0, (double)0.0);
    protected static final VoxelShape SIDE3 = Block.func_208617_a((double)16.0, (double)16.0, (double)15.0, (double)0.0, (double)0.0, (double)16.0);
    protected static final VoxelShape SIDE4 = Block.func_208617_a((double)15.0, (double)16.0, (double)16.0, (double)16.0, (double)0.0, (double)0.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{SIDE1, SIDE2, SIDE3, SIDE4});
    protected static final VoxelShape CLOSED = Block.func_208617_a((double)16.0, (double)16.0, (double)16.0, (double)0.0, (double)0.0, (double)0.0);

    public BrewingBarrelBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(0))).func_206870_a((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getProgress(state) > 0 ? CLOSED : SHAPE;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BrewingBarrelTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LAYERS, PROGRESS});
    }

    public int getProgress(BlockState state) {
        return (Integer)state.func_177229_b((Property)PROGRESS);
    }

    public int getLayers(BlockState state) {
        return (Integer)state.func_177229_b((Property)LAYERS);
    }

    private boolean readyToFerment(BlockState state) {
        return this.getLayers(state) == 1;
    }

    public void reset(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(0))).func_206870_a((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BrewingBarrelTileEntity) {
            if (player.func_225608_bj_() && this.getLayers(state) == 1 && this.getProgress(state) == 0) {
                this.dropItem(worldIn, pos);
                state = (BlockState)state.func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(0));
                worldIn.func_175656_a(pos, state);
                return ActionResultType.SUCCESS;
            }
            if (this.isAlcoholIngredient(worldIn, player.func_184614_ca()) && ((BrewingBarrelTileEntity)tileentity).getCapacity() == 0) {
                this.insertItem((IWorld)worldIn, pos, state, player.func_184614_ca().func_77973_b());
                player.func_184614_ca().func_190918_g(1);
                state = (BlockState)state.func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(1));
                worldIn.func_175656_a(pos, state);
                return ActionResultType.SUCCESS;
            }
            if (player.func_184614_ca().func_77973_b() == Items.field_151069_bo && this.getProgress(state) == 3) {
                player.func_191521_c(this.getProduct(worldIn, ((BrewingBarrelTileEntity)tileentity).getItem()));
                ((BrewingBarrelTileEntity)tileentity).func_174888_l();
                worldIn.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                player.func_184614_ca().func_190918_g(1);
                this.reset(state, worldIn, pos);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void insertItem(IWorld worldIn, BlockPos pos, BlockState state, Item item) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BrewingBarrelTileEntity && ((BrewingBarrelTileEntity)tileentity).getCapacity() == 0) {
            ((BrewingBarrelTileEntity)tileentity).setItem(item);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    private void dropItem(World worldIn, BlockPos pos) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof BrewingBarrelTileEntity) {
            BrewingBarrelTileEntity tile = (BrewingBarrelTileEntity)tileentity;
            Item item = tile.getItem();
            if (tile.getCapacity() > 0) {
                worldIn.func_217379_c(1010, pos, 0);
                tile.func_174888_l();
                double d0 = worldIn.field_73012_v.nextFloat() * 0.7f + 0.15f;
                double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.7f + 0.060000002f) + 0.6;
                double d2 = worldIn.field_73012_v.nextFloat() * 0.7f + 0.15f;
                ItemStack stack = new ItemStack((IItemProvider)item);
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropItem(worldIn, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int i;
        if (this.readyToFerment(state) && (i = ((Integer)state.func_177229_b((Property)PROGRESS)).intValue()) < 3 && random.nextInt(5) == 0) {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)LAYERS, (Comparable)Integer.valueOf(1))).func_206870_a((Property)PROGRESS, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.getProgress(stateIn) < 3 && this.getProgress(stateIn) > 0) {
            double d0 = (double)pos.func_177958_n() + Math.random();
            double d1 = (double)pos.func_177956_o() + Math.random();
            double d2 = (double)pos.func_177952_p() + Math.random();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197608_a, d0, d1 + 1.0, d2, 0.0, 0.0, 0.0);
        }
    }

    public ItemStack getProduct(World worldIn, Item itemIn) {
        return worldIn.func_199532_z().func_215371_a(ModRecipes.BREWING_BARREL_RECIPE_TYPE, (IInventory)new Inventory(new ItemStack[]{new ItemStack((IItemProvider)itemIn)}), worldIn).map(recipe -> recipe.func_77572_b(null)).orElse(ItemStack.field_190927_a);
    }

    public boolean isAlcoholIngredient(World worldIn, ItemStack itemstackIn) {
        return worldIn.func_199532_z().func_215371_a(ModRecipes.BREWING_BARREL_RECIPE_TYPE, (IInventory)new Inventory(new ItemStack[]{itemstackIn}), worldIn).isPresent();
    }
}

