/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse.entity;

import epicsquid.traverse.init.ModBlocks;
import epicsquid.traverse.init.ModItems;
import epicsquid.traverse.item.FirBoatItem;
import epicsquid.traverse.repack.registrate.util.entry.RegistryEntry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TerraformBoatEntity
extends BoatEntity {
    private static ResourceLocation FIR_SKIN = new ResourceLocation("traverse", "textures/entity/boat/fir.png");
    private TerraformBoat boat;

    public TerraformBoatEntity(EntityType<? extends BoatEntity> type, World world, TerraformBoat boat) {
        super(type, world);
        this.boat = boat;
    }

    public Item asItem() {
        return this.boat.getBoatItem();
    }

    public Item asPlanks() {
        return this.boat.getPlanks();
    }

    public ResourceLocation getSkin() {
        return this.boat.getSkin();
    }

    private boolean isOnLand() {
        return this.func_193047_k() == SoundEvents.field_193778_H;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        float savedFallDistance = this.field_70143_R;
        super.func_184231_a(y, false, state, pos);
        if (!this.func_184218_aH() && onGroundIn) {
            this.field_70143_R = savedFallDistance;
            if (this.field_70143_R > 3.0f) {
                if (!this.isOnLand()) {
                    this.field_70143_R = 0.0f;
                    return;
                }
                this.func_225503_b_(this.field_70143_R, 1.0f);
                if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
                    this.func_70106_y();
                    if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.func_199703_a((IItemProvider)this.asPlanks());
                        }
                        for (i = 0; i < 2; ++i) {
                            this.func_199703_a((IItemProvider)Items.field_151055_y);
                        }
                    }
                }
            }
            this.field_70143_R = 0.0f;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184458_a(BoatEntity.Type type) {
        throw new UnsupportedOperationException("Cannot change type of Terraform/Traverse boat");
    }

    public BoatEntity.Type func_184453_r() {
        return this.boat.getType();
    }

    static /* synthetic */ ResourceLocation access$000() {
        return FIR_SKIN;
    }

    public static class FirBoatEntity
    extends TerraformBoatEntity {
        private static TerraformBoat FIR_BOAT = new TerraformBoat(ModItems.FIR_BOAT, ModBlocks.FIR_PLANKS, TerraformBoatEntity.access$000(), BoatEntity.Type.OAK);

        public FirBoatEntity(EntityType<? extends BoatEntity> type, World world) {
            super(type, world, FIR_BOAT);
        }
    }

    public static class TerraformBoat {
        private RegistryEntry<FirBoatItem> boatItem;
        private RegistryEntry<Block> planks;
        private ResourceLocation skin;
        private BoatEntity.Type type;

        public TerraformBoat(RegistryEntry<FirBoatItem> boatItem, RegistryEntry<Block> planks, ResourceLocation skin) {
            this(boatItem, planks, skin, BoatEntity.Type.OAK);
        }

        public TerraformBoat(RegistryEntry<FirBoatItem> boatItem, RegistryEntry<Block> planks, ResourceLocation skin, BoatEntity.Type type) {
            this.boatItem = boatItem;
            this.planks = planks;
            this.skin = skin;
            this.type = type;
        }

        public Item getBoatItem() {
            return this.boatItem.get();
        }

        public Item getPlanks() {
            return this.planks.get().func_199767_j();
        }

        public ResourceLocation getSkin() {
            return this.skin;
        }

        public BoatEntity.Type getType() {
            return this.type;
        }
    }
}

