/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse.biomebuilder;

import epicsquid.traverse.biomebuilder.BuilderBiomeSettings;
import epicsquid.traverse.biomebuilder.DefaultFeature;
import epicsquid.traverse.biomebuilder.FeatureEntry;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;

public final class TerraformBiomeBuilder
extends BuilderBiomeSettings {
    private final ArrayList<DefaultFeature> defaultFeatures = new ArrayList();
    private final ArrayList<FeatureEntry> features = new ArrayList();
    private final ArrayList<StructureFeature<? extends IFeatureConfig, ? extends Structure<? extends IFeatureConfig>>> structureFeatures = new ArrayList();
    private final ArrayList<MobSpawnInfo.Spawners> spawnEntries = new ArrayList();
    private float spawnChance = -1.0f;
    private boolean template = false;
    private boolean playerSpawnFriendly = false;

    private TerraformBiomeBuilder() {
        this.parent(null);
    }

    public TerraformBiomeBuilder(TerraformBiomeBuilder existing) {
        super(existing);
        this.defaultFeatures.addAll(existing.defaultFeatures);
        this.features.addAll(existing.features);
        this.structureFeatures.addAll(existing.structureFeatures);
        this.spawnEntries.addAll(existing.spawnEntries);
        this.spawnChance = existing.spawnChance;
        this.playerSpawnFriendly = existing.playerSpawnFriendly;
    }

    public Biome build() {
        if (this.template) {
            throw new IllegalStateException("Tried to call build() on a frozen Builder instance!");
        }
        Biome.Builder builder = new Biome.Builder();
        builder.func_205419_a(this.category);
        builder.func_205421_a(this.depth.floatValue());
        builder.func_205420_b(this.scale.floatValue());
        builder.func_205417_d(this.downfall.floatValue());
        builder.func_205415_a(this.precipitation);
        builder.func_205414_c(this.temperature.floatValue());
        builder.func_235097_a_(this.effects.func_235238_a_());
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(this.surfaceBuilder);
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        if (this.spawnChance != -1.0f) {
            spawnSettings.func_242572_a(this.spawnChance);
        }
        for (MobSpawnInfo.Spawners spawners : this.spawnEntries) {
            spawnSettings.func_242575_a(spawners.field_242588_c.func_220339_d(), spawners);
        }
        if (this.playerSpawnFriendly) {
            spawnSettings.func_242571_a();
        }
        for (StructureFeature structureFeature : this.structureFeatures) {
            generationSettings.func_242516_a(structureFeature);
        }
        for (DefaultFeature defaultFeature : this.defaultFeatures) {
            defaultFeature.add(generationSettings);
        }
        for (FeatureEntry featureEntry : this.features) {
            generationSettings.func_242513_a(featureEntry.getStage(), featureEntry.getFeature());
        }
        builder.func_242457_a(generationSettings.func_242508_a());
        builder.func_242458_a(spawnSettings.func_242577_b());
        return builder.func_242455_a();
    }

    @Override
    public TerraformBiomeBuilder surfaceBuilder(ConfiguredSurfaceBuilder<?> surfaceBuilder) {
        super.surfaceBuilder(surfaceBuilder);
        return this;
    }

    @Override
    public TerraformBiomeBuilder precipitation(Biome.RainType precipitation) {
        super.precipitation(precipitation);
        return this;
    }

    @Override
    public TerraformBiomeBuilder category(Biome.Category category) {
        super.category(category);
        return this;
    }

    @Override
    public TerraformBiomeBuilder depth(float depth) {
        super.depth(depth);
        return this;
    }

    @Override
    public TerraformBiomeBuilder scale(float scale) {
        super.scale(scale);
        return this;
    }

    @Override
    public TerraformBiomeBuilder temperature(float temperature) {
        super.temperature(temperature);
        return this;
    }

    @Override
    public TerraformBiomeBuilder downfall(float downfall) {
        super.downfall(downfall);
        return this;
    }

    @Override
    public TerraformBiomeBuilder parent(String parent) {
        super.parent(parent);
        return this;
    }

    @Override
    public TerraformBiomeBuilder effects(BiomeAmbience.Builder effects) {
        super.effects(effects);
        return this;
    }

    public TerraformBiomeBuilder addFeature(GenerationStage.Decoration step, ConfiguredFeature feature) {
        this.features.add(new FeatureEntry(step, feature));
        return this;
    }

    public TerraformBiomeBuilder addSpawnEntry(MobSpawnInfo.Spawners entry) {
        this.spawnEntries.add(entry);
        return this;
    }

    public TerraformBiomeBuilder addStructureFeature(StructureFeature<? extends IFeatureConfig, ? extends Structure<? extends IFeatureConfig>> stucture) {
        this.structureFeatures.add(stucture);
        return this;
    }

    public TerraformBiomeBuilder addDefaultFeature(DefaultFeature feature) {
        this.defaultFeatures.add(feature);
        return this;
    }

    public TerraformBiomeBuilder addDefaultFeatures(DefaultFeature ... features) {
        this.defaultFeatures.addAll(Arrays.asList(features));
        return this;
    }

    public TerraformBiomeBuilder addDefaultSpawnEntries() {
        this.addDefaultCreatureSpawnEntries().addDefaultAmbientSpawnEntries().addDefaultMonsterSpawnEntries();
        return this;
    }

    public TerraformBiomeBuilder addDefaultCreatureSpawnEntries() {
        this.addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 12, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200784_X, 10, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200795_i, 10, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200796_j, 8, 4, 4));
        return this;
    }

    public TerraformBiomeBuilder addDefaultAmbientSpawnEntries() {
        this.addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 8, 8));
        return this;
    }

    public TerraformBiomeBuilder addDefaultMonsterSpawnEntries() {
        this.addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200748_an, 100, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 95, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200727_aF, 5, 1, 1)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 100, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200797_k, 100, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 100, 4, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200803_q, 10, 1, 4)).addSpawnEntry(new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 5, 1, 1));
        return this;
    }

    public TerraformBiomeBuilder playerSpawnFriendly() {
        this.playerSpawnFriendly = true;
        return this;
    }

    void markTemplate() {
        this.template = true;
    }

    public static TerraformBiomeBuilder create() {
        return new TerraformBiomeBuilder();
    }
}

