/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.traverse.biome;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;

public class BiomeVariants {
    public static Random rand = new Random();
    private static Map<RegistryKey<Biome>, Entry> hillReplacements = new HashMap<RegistryKey<Biome>, Entry>();
    private static Map<RegistryKey<Biome>, Entry> riverReplacements = new HashMap<RegistryKey<Biome>, Entry>();
    private static Map<RegistryKey<Biome>, Entry> edgeReplacements = new HashMap<RegistryKey<Biome>, Entry>();
    private static Map<RegistryKey<Biome>, Entry> centerReplacements = new HashMap<RegistryKey<Biome>, Entry>();
    private static Map<RegistryKey<Biome>, Entry> shoreReplacements = new HashMap<RegistryKey<Biome>, Entry>();
    private static Map<RegistryKey<Biome>, WeightedEntryList> biomeReplacements = new HashMap<RegistryKey<Biome>, WeightedEntryList>();
    private static EnumMap<VariantType, Map<RegistryKey<Biome>, Entry>> map = new EnumMap(VariantType.class);

    public static void addReplacement(RegistryKey<Biome> replacing, RegistryKey<Biome> replacement, double chance, VariantType type) {
        if (type != VariantType.BIOME) {
            Map<RegistryKey<Biome>, Entry> current = map.get((Object)type);
            current.put(replacing, Entry.of(replacement));
        } else {
            WeightedEntryList entries = biomeReplacements.computeIfAbsent(replacing, k -> new WeightedEntryList());
            if (entries.entries.isEmpty()) {
                entries.add(replacing, 1.0 - chance);
            }
            entries.add(replacement, chance);
        }
    }

    @Nullable
    public static RegistryKey<Biome> pickReplacement(INoiseRandom random, RegistryKey<Biome> replacing, VariantType type) {
        if (type != VariantType.BIOME) {
            return map.get((Object)type).computeIfAbsent(replacing, k -> Entry.EMPTY).getReplacement();
        }
        WeightedEntryList entries = biomeReplacements.get(replacing);
        if (entries == null) {
            return null;
        }
        return entries.getReplacement(random);
    }

    static {
        map.put(VariantType.HILLS, hillReplacements);
        map.put(VariantType.RIVER, riverReplacements);
        map.put(VariantType.EDGE, edgeReplacements);
        map.put(VariantType.CENTER, edgeReplacements);
        map.put(VariantType.SHORE, shoreReplacements);
    }

    private static class WeightedEntryList
    implements IEntry {
        private final List<WeightedEntry> entries = new ArrayList<WeightedEntry>();
        private double total = 0.0;

        public void add(RegistryKey<Biome> replacement, double weight) {
            this.total += weight;
            this.entries.add(new WeightedEntry(replacement, weight, this.total));
        }

        public double getTotal() {
            return this.total;
        }

        @Override
        public RegistryKey<Biome> getReplacement() {
            return null;
        }

        @Override
        public RegistryKey<Biome> getReplacement(INoiseRandom random) {
            if (this.entries.size() == 1) {
                return this.entries.get(0).getReplacement();
            }
            return this.search((double)random.func_202696_a(Integer.MAX_VALUE) * this.getTotal() / 2.147483647E9).getReplacement();
        }

        private WeightedEntry search(double target) {
            int min = 0;
            int max = this.entries.size();
            while (min < max) {
                int mid = max + min >>> 1;
                if (target < this.entries.get(mid).getCurrentTotal()) {
                    max = mid;
                    continue;
                }
                min = mid + 1;
            }
            return this.entries.get(min);
        }
    }

    private static class WeightedEntry
    implements IEntry {
        private final RegistryKey<Biome> replacement;
        private final double chance;
        private final double currentTotal;

        public WeightedEntry(RegistryKey<Biome> replacement, double chance, double currentTotal) {
            this.replacement = replacement;
            this.chance = chance;
            this.currentTotal = currentTotal;
        }

        @Override
        public RegistryKey<Biome> getReplacement() {
            return this.replacement;
        }

        public double getChance() {
            return this.chance;
        }

        public double getCurrentTotal() {
            return this.currentTotal;
        }
    }

    private static class Entry
    implements IEntry {
        public static final Entry EMPTY = new Entry(null);
        private final RegistryKey<Biome> replacement;

        public Entry(RegistryKey<Biome> replacement) {
            this.replacement = replacement;
        }

        @Override
        public RegistryKey<Biome> getReplacement() {
            return this.replacement;
        }

        public static Entry of(RegistryKey<Biome> replacement) {
            return new Entry(replacement);
        }
    }

    private static interface IEntry {
        public RegistryKey<Biome> getReplacement();

        default public RegistryKey<Biome> getReplacement(INoiseRandom random) {
            return this.getReplacement();
        }
    }

    public static enum VariantType {
        HILLS,
        BIOME,
        RIVER,
        EDGE,
        CENTER,
        SHORE;

    }
}

