/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.UnaryOperator;
import net.minecraft.util.text.ITextComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.template.TemplateComponent;

public class ComponentText
extends TemplateComponent {
    public IVariable text;
    @SerializedName(value="color")
    public IVariable colorStr;
    @SerializedName(value="max_width")
    int maxWidth = 116;
    @SerializedName(value="line_height")
    int lineHeight = 9;
    transient ITextComponent actualText;
    transient BookTextRenderer textRenderer;
    transient int color;

    @Override
    public void build(BookPage page, BookEntry entry, int pageNum) {
        try {
            this.color = Integer.parseInt(this.colorStr.asString(""), 16);
        }
        catch (NumberFormatException e) {
            this.color = page.book.textColor;
        }
    }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        super.onVariablesAvailable(lookup);
        this.actualText = ((IVariable)lookup.apply(this.text)).as(ITextComponent.class);
        this.colorStr = (IVariable)lookup.apply(this.colorStr);
    }

    @Override
    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.textRenderer = new BookTextRenderer(parent, this.actualText.getString(), this.x, this.y, this.maxWidth, this.lineHeight, this.color);
    }

    @Override
    public void render(MatrixStack ms, BookPage page, int mouseX, int mouseY, float pticks) {
        this.textRenderer.render(ms, mouseX, mouseY);
    }

    @Override
    public boolean func_231043_a_(BookPage page, double mouseX, double mouseY, int mouseButton) {
        return this.textRenderer.click(mouseX, mouseY, mouseButton);
    }
}

