/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonCategory
extends Button {
    private static final int ANIM_TIME = 5;
    final GuiBook parent;
    BookCategory category;
    final BookIcon icon;
    final ITextComponent name;
    final int u;
    final int v;
    float timeHovered;

    public GuiButtonCategory(GuiBook parent, int x, int y, BookCategory category, Button.IPressable onPress) {
        this(parent, x, y, category.getIcon(), category.getName(), onPress);
        this.category = category;
    }

    public GuiButtonCategory(GuiBook parent, int x, int y, BookIcon icon, ITextComponent name, Button.IPressable onPress) {
        super(parent.bookLeft + x, parent.bookTop + y, 20, 20, name, onPress);
        this.parent = parent;
        this.u = x;
        this.v = y;
        this.icon = icon;
        this.name = name;
    }

    public void func_230431_b_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230693_o_) {
            boolean locked;
            this.timeHovered = this.func_230449_g_() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.func_230449_g_() ? partialTicks : -partialTicks)));
            float transparency = 0.5f - time / 5.0f * 0.5f;
            boolean bl = locked = this.category != null && this.category.isLocked();
            if (locked) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(ms, this.parent.book, this.field_230690_l_ + 2, this.field_230691_m_ + 2);
            } else {
                this.icon.render(ms, this.field_230690_l_ + 2, this.field_230691_m_ + 2);
            }
            ms.func_227860_a_();
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            ms.func_227861_a_(0.0, 0.0, 200.0);
            GuiBook.drawFromTexture(ms, this.parent.book, this.field_230690_l_, this.field_230691_m_, this.u, this.v, this.field_230688_j_, this.field_230689_k_);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.category != null && !this.category.isLocked()) {
                GuiBook.drawMarking(ms, this.parent.book, this.field_230690_l_, this.field_230691_m_, 0, this.category.getReadState());
            }
            ms.func_227865_b_();
            if (this.func_230449_g_()) {
                this.parent.setTooltip(new ITextComponent[]{locked ? new TranslationTextComponent("patchouli.gui.lexicon.locked").func_240699_a_(TextFormatting.GRAY) : this.name});
            }
        }
    }

    public void func_230988_a_(SoundHandler soundHandlerIn) {
        if (this.category != null && !this.category.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookCategory getCategory() {
        return this.category;
    }
}

