/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.objects;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class FortuneBonusModifier
extends LootModifier {
    protected FortuneBonusModifier(ILootCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (tool == null || tool.func_77942_o() && tool.func_77978_p() != null && tool.func_77978_p().func_74767_n("HasCuriosFortuneBonus")) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        if (blockState == null || !(entity instanceof LivingEntity)) {
            return generatedLoot;
        }
        LivingEntity player = (LivingEntity)entity;
        int totalFortuneBonus = CuriosApi.getCuriosHelper().getCuriosHandler(player).map(ICuriosItemHandler::getFortuneBonus).orElse(0);
        if (totalFortuneBonus <= 0) {
            return generatedLoot;
        }
        ItemStack fakeTool = tool.func_190926_b() ? new ItemStack((IItemProvider)Items.field_221803_eL) : tool.func_77946_l();
        fakeTool.func_196082_o().func_74757_a("HasCuriosFortuneBonus", true);
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)fakeTool);
        enchantments.put(Enchantments.field_185308_t, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)fakeTool) + totalFortuneBonus);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)fakeTool);
        LootContext.Builder builder = new LootContext.Builder(context);
        builder.func_216015_a(LootParameters.field_216289_i, (Object)fakeTool);
        LootContext newContext = builder.func_216022_a(LootParameterSets.field_216267_h);
        LootTable lootTable = context.func_202879_g().func_73046_m().func_200249_aQ().func_186521_a(blockState.func_177230_c().func_220068_i());
        return lootTable.func_216113_a(newContext);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<FortuneBonusModifier> {
        public FortuneBonusModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new FortuneBonusModifier(conditions);
        }

        public JsonObject write(FortuneBonusModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

