/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.DynamicStackHandler;

public class CurioStacksHandler
implements ICurioStacksHandler {
    private IDynamicStackHandler stackHandler;
    private IDynamicStackHandler cosmeticStackHandler;
    private int sizeShift;
    private boolean visible;
    private boolean cosmetic;
    private NonNullList<Boolean> renderHandler;

    public CurioStacksHandler() {
        this(1, 0, true, false);
    }

    public CurioStacksHandler(int size, int shift, boolean visible, boolean cosmetic) {
        this.setSize(size + shift);
        this.sizeShift = shift;
        this.visible = visible;
        this.cosmetic = cosmetic;
    }

    public void setSize(int size) {
        this.stackHandler = new DynamicStackHandler(size);
        this.cosmeticStackHandler = new DynamicStackHandler(size);
        this.renderHandler = NonNullList.func_191197_a((int)size, (Object)true);
        this.sizeShift = 0;
    }

    @Override
    public IDynamicStackHandler getStacks() {
        return this.stackHandler;
    }

    @Override
    public IDynamicStackHandler getCosmeticStacks() {
        return this.cosmeticStackHandler;
    }

    @Override
    public NonNullList<Boolean> getRenders() {
        return this.renderHandler;
    }

    @Override
    public int getSlots() {
        return this.stackHandler.getSlots();
    }

    @Override
    public int getSizeShift() {
        return this.sizeShift;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean hasCosmetic() {
        return this.cosmetic;
    }

    @Override
    public void grow(int amount) {
        this.validateSizeChange(amount);
        this.stackHandler.grow(amount);
        this.cosmeticStackHandler.grow(amount);
        NonNullList newList = NonNullList.func_191197_a((int)(this.renderHandler.size() + amount), (Object)true);
        for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
            newList.set(i, this.renderHandler.get(i));
        }
        this.renderHandler = newList;
        this.sizeShift += amount;
    }

    @Override
    public void shrink(int amount) {
        this.validateSizeChange(amount);
        amount = Math.min(this.stackHandler.getSlots() - 1, amount);
        this.stackHandler.shrink(amount);
        this.cosmeticStackHandler.shrink(amount);
        NonNullList newList = NonNullList.func_191197_a((int)(this.renderHandler.size() - amount), (Object)true);
        for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
            newList.set(i, this.renderHandler.get(i));
        }
        this.renderHandler = newList;
        this.sizeShift -= amount;
    }

    private void validateSizeChange(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount cannot be negative!");
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_218657_a("Stacks", (INBT)this.stackHandler.serializeNBT());
        compoundNBT.func_218657_a("Cosmetics", (INBT)this.cosmeticStackHandler.serializeNBT());
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("Slot", i);
            tag.func_74757_a("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Renders", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.renderHandler.size());
        compoundNBT.func_218657_a("Renders", (INBT)nbt);
        compoundNBT.func_74768_a("SizeShift", this.sizeShift);
        compoundNBT.func_74757_a("HasCosmetic", this.cosmetic);
        compoundNBT.func_74757_a("Visible", this.visible);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("Stacks")) {
            this.stackHandler.deserializeNBT(nbt.func_74775_l("Stacks"));
        }
        if (nbt.func_74764_b("Cosmetics")) {
            this.cosmeticStackHandler.deserializeNBT(nbt.func_74775_l("Cosmetics"));
        }
        if (nbt.func_74764_b("Renders")) {
            CompoundNBT tag = nbt.func_74775_l("Renders");
            this.renderHandler = NonNullList.func_191197_a((int)(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stackHandler.getSlots()), (Object)true);
            ListNBT tagList = tag.func_150295_c("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tags = tagList.func_150305_b(i);
                int slot = tags.func_74762_e("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.func_74767_n("Render"));
            }
        }
        if (nbt.func_74764_b("SizeShift")) {
            this.sizeShift = nbt.func_74762_e("SizeShift");
        }
        this.cosmetic = nbt.func_74764_b("HasCosmetic") ? nbt.func_74767_n("HasCosmetic") : this.cosmetic;
        this.visible = nbt.func_74764_b("Visible") ? nbt.func_74767_n("Visible") : this.visible;
    }
}

