/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioSlot
extends SlotItemHandler {
    private final String identifier;
    private final PlayerEntity player;
    private NonNullList<Boolean> renderStatuses;

    public CurioSlot(PlayerEntity player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.identifier = identifier;
        this.renderStatuses = renders;
        this.player = player;
        this.setBackground(PlayerContainer.field_226615_c_, player.func_130014_f_().func_201670_d() ? CuriosApi.getIconHelper().getIcon(identifier) : new ResourceLocation("curios", "item/empty_curio_slot"));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean getRenderStatus() {
        return (Boolean)this.renderStatuses.get(this.getSlotIndex());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        return I18n.func_135052_a((String)("curios.identifier." + this.identifier), (Object[])new Object[0]);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return this.hasValidTag(CuriosApi.getCuriosHelper().getCurioTags(stack.func_77973_b())) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canEquip(this.identifier, (LivingEntity)this.player)).orElse(true) != false && super.func_75214_a(stack);
    }

    protected boolean hasValidTag(Set<String> tags) {
        return !tags.isEmpty() && this.identifier.equals(SlotTypePreset.CURIO.getIdentifier()) || tags.contains(this.identifier) || tags.contains(SlotTypePreset.CURIO.getIdentifier());
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        ItemStack stack = this.func_75211_c();
        return (stack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)stack)) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canUnequip(this.identifier, (LivingEntity)playerIn)).orElse(true) != false && super.func_82869_a(playerIn);
    }
}

