/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import top.theillusivec4.polymorph.api.PolymorphCapability;
import top.theillusivec4.polymorph.client.selector.CraftingRecipeSelector;

public class MixinHooks {
    public static void sendCraftingUpdate() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MixinHooks.getRunnableUpdate().run();
        }
    }

    private static DistExecutor.SafeRunnable getRunnableUpdate() {
        return CraftingRecipeSelector::update;
    }

    public static <C extends IInventory, T extends IRecipe<C>> Optional<T> getSelectedRecipe(IRecipeType<T> recipeType, C inventory, World world) {
        if (inventory instanceof TileEntity) {
            TileEntity te = (TileEntity)inventory;
            LazyOptional cap = te.getCapability(PolymorphCapability.PERSISTENT_SELECTOR);
            ArrayList recipe = new ArrayList();
            cap.ifPresent(selector -> {
                ItemStack input = inventory.func_70301_a(0);
                if (!input.func_190926_b()) {
                    Optional<IRecipe<?>> maybeSelected = selector.getSelectedRecipe();
                    maybeSelected.ifPresent(res -> {
                        if (res.func_77569_a(inventory, world)) {
                            recipe.add(res);
                        } else {
                            selector.fetchRecipe(world).ifPresent(res1 -> recipe.add(res1));
                        }
                    });
                    if (!maybeSelected.isPresent()) {
                        selector.fetchRecipe(world).ifPresent(res1 -> recipe.add(res1));
                    }
                }
            });
            return recipe.isEmpty() ? Optional.empty() : Optional.of(recipe.get(0));
        }
        return Optional.empty();
    }
}

