/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import top.theillusivec4.polymorph.client.gui.RecipeOutputWidget;

public class RecipeSelectorGui<I extends IInventory, R extends IRecipe<I>>
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    private final Consumer<R> select;
    private final I inventory;
    private final Screen screen;
    private final List<RecipeOutputWidget<I, R>> buttons = new ArrayList<RecipeOutputWidget<I, R>>();
    private RecipeOutputWidget<I, R> hoveredButton;
    private boolean visible = false;
    private int x;
    private int y;
    private List<R> recipes = new ArrayList<R>();

    public RecipeSelectorGui(int x, int y, I inventory, Consumer<R> select, Screen screen) {
        this.setPosition(x, y);
        this.select = select;
        this.inventory = inventory;
        this.screen = screen;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    public void highlightButton(String recipe) {
        this.buttons.forEach(button -> {
            String id = button.recipe.func_199560_c().toString();
            button.highlighted = id.equals(recipe);
        });
    }

    private void updateButtonPositions() {
        int size = this.recipes.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.buttons.forEach(button -> {
            button.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<RecipeOutputWidget<I, R>> getButtons() {
        return this.buttons;
    }

    public void setRecipes(List<R> recipes) {
        this.recipes = recipes;
        this.buttons.clear();
        recipes.forEach(recipe -> this.buttons.add(new RecipeOutputWidget<I, IRecipe>(this.inventory, (IRecipe)recipe)));
        this.updateButtonPositions();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void renderTooltip(MatrixStack matrixStack, int p_193721_1_, int p_193721_2_) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && this.hoveredButton != null) {
            this.renderTooltip(this.hoveredButton.getOutput(), matrixStack, this.hoveredButton.getTooltipText(mc.field_71462_r), p_193721_1_, p_193721_2_);
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.isVisible()) {
            this.hoveredButton = null;
            this.buttons.forEach(button -> {
                button.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
                if (button.field_230694_p_ && button.func_230449_g_()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(matrixStack, p_render_1_, p_render_2_);
        }
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isVisible()) {
            for (RecipeOutputWidget<I, R> button : this.buttons) {
                if (!button.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) continue;
                this.select.accept(button.recipe);
                return true;
            }
        }
        return false;
    }

    public void renderTooltip(ItemStack stack, MatrixStack p_243308_1_, List<ITextComponent> p_243308_2_, int p_243308_3_, int p_243308_4_) {
        RecipeSelectorGui.drawHoveringText(stack, p_243308_1_, p_243308_2_, p_243308_3_, p_243308_4_, this.screen.field_230708_k_, this.screen.field_230709_l_, -1, -267386864, 0x505000FF, 1344798847, this.screen.getMinecraft().field_71466_p);
    }

    public static void drawHoveringText(@Nonnull ItemStack stack, MatrixStack mStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, FontRenderer font) {
        if (!textLines.isEmpty()) {
            int n;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, mStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (ITextProperties iTextProperties : textLines) {
                int textLineWidth = font.func_238414_a_(iTextProperties);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
                for (int i = 0; i < textLines.size(); ++i) {
                    ITextProperties textLine = textLines.get(i);
                    List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (ITextProperties line : wrappedLine) {
                        int lineWidth = font.func_238414_a_(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((ITextProperties)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 900;
            RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, textLines, mStack, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)colorEvent);
            backgroundColor = colorEvent.getBackground();
            borderColorStart = colorEvent.getBorderStart();
            borderColorEnd = colorEvent.getBorderEnd();
            mStack.func_227860_a_();
            Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)900, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, mStack, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
            IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            mStack.func_227861_a_(0.0, 0.0, 900.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                ITextProperties line = textLines.get(lineNumber);
                if (line != null) {
                    font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.func_228461_a_();
            mStack.func_227865_b_();
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, mStack, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }
}

