/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class CheckDimensionId
implements ILootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation dimensionId;

    public CheckDimensionId(ResourceLocation dimensionId) {
        this.dimensionId = dimensionId;
    }

    public boolean test(LootContext ctx) {
        ServerWorld world = ctx.func_202879_g();
        RegistryKey dimension = world.func_234923_W_();
        return dimension != null && dimension.func_240901_a_().equals((Object)this.dimensionId);
    }

    public LootConditionType func_230419_b_() {
        return Bookshelf.instance.conditionCheckDimension;
    }

    static class Serializer
    implements ILootSerializer<CheckDimensionId> {
        Serializer() {
        }

        public CheckDimensionId deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation id = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)"dimension"));
            return new CheckDimensionId(id);
        }

        public void serialize(JsonObject json, CheckDimensionId value, JsonSerializationContext context) {
            json.addProperty("dimension", value.dimensionId.toString());
        }
    }
}

