/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.ItemStackHandler;

public class ItemHandler<T extends ItemHandler<T>>
extends ItemStackHandler {
    private IntFunction<Integer> maxSize = x$0 -> super.getSlotLimit(x$0);
    private BiPredicate<Integer, ItemStack> validItems = (x$0, x$1) -> super.isItemValid(x$0, x$1);
    private final List<Consumer<Integer>> changeListener = new ArrayList<Consumer<Integer>>();

    public ItemHandler() {
        this(1);
    }

    public ItemHandler(int invSize) {
        super(invSize);
    }

    public T withMaxSize(int maxSize) {
        return this.withMaxSize(slot -> maxSize);
    }

    public T withMaxSize(int[] maxSizes) {
        return this.withMaxSize(maxSizes, 0);
    }

    public T withMaxSize(int[] maxSizes, int defaultSize) {
        return this.withMaxSize(slot -> slot >= 0 && slot < maxSizes.length ? maxSizes[slot] : defaultSize);
    }

    public T withMaxSize(IntFunction<Integer> maxSizeFunc) {
        this.maxSize = maxSizeFunc;
        return this.self();
    }

    public T withItemValidator(boolean isValid) {
        return this.withItemValidator((Integer slot, ItemStack stack) -> isValid);
    }

    public T withItemValidator(IItemProvider ... items) {
        return this.withItemValidator((Predicate<ItemStack>)Ingredient.func_199804_a((IItemProvider[])items));
    }

    public T withItemValidator(ITag<Item> tag) {
        return this.withItemValidator((Predicate<ItemStack>)Ingredient.func_199805_a(tag));
    }

    public T withItemValidator(Predicate<ItemStack> validator) {
        return this.withItemValidator((Integer slot, ItemStack stack) -> validator.test((ItemStack)stack));
    }

    public T withItemValidator(BiPredicate<Integer, ItemStack> validator) {
        this.validItems = validator;
        return this.self();
    }

    public T withChangeListener(Runnable listener) {
        return this.withChangeListener((Integer i) -> listener.run());
    }

    public T withChangeListener(BiConsumer<Integer, ItemStack> listener) {
        return this.withChangeListener((Integer slot) -> listener.accept((Integer)slot, this.getStackInSlot((int)slot)));
    }

    public T withChangeListener(Consumer<Integer> listener) {
        this.changeListener.add(listener);
        return this.self();
    }

    public int getSlotLimit(int slot) {
        return this.maxSize.apply(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.validItems.test(slot, stack);
    }

    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.changeListener.forEach(listener -> listener.accept(slot));
    }

    public T self() {
        return (T)((Object)this);
    }
}

