/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.internal.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.StringJoiner;
import java.util.function.Function;
import net.darkhax.bookshelf.internal.command.ArgumentTypeHandOutput;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class CommandHand {
    public CommandHand(LiteralArgumentBuilder<CommandSource> root) {
        root.then(Commands.func_197057_a((String)"hand").then(Commands.func_197056_a((String)"type", (ArgumentType)new ArgumentTypeHandOutput()).executes(this::hand)));
    }

    private int hand(CommandContext<CommandSource> context) throws CommandSyntaxException {
        OutputType type = (OutputType)((Object)context.getArgument("type", OutputType.class));
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        String outputText = (String)type.converter.apply(player.func_184614_ca());
        IFormattableTextComponent component = TextComponentUtils.func_240647_a_((ITextComponent)new StringTextComponent(outputText).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, outputText)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.copy.click"))).func_240714_a_(outputText)));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)component, false);
        return 0;
    }

    public static enum OutputType {
        STRING(OutputType::getAsString),
        INGREDIENT(OutputType::getAsIngredient),
        STACKJSON(OutputType::getAsStackJson),
        ID(OutputType::getAsID),
        HOLDER(OutputType::getAsHolder),
        TAGS(OutputType::getTags),
        FLUIDS(OutputType::getFluids);

        private final Function<ItemStack, String> converter;

        private OutputType(Function<ItemStack, String> converter) {
            this.converter = converter;
        }

        private static String getAsString(ItemStack stack) {
            return stack.toString();
        }

        private static String getAsIngredient(ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)(stack.func_77942_o() ? NBTIngredient.Serializer.INSTANCE : VanillaIngredientSerializer.INSTANCE)).toString());
            json.addProperty("item", stack.func_77973_b().getRegistryName().toString());
            json.addProperty("count", (Number)stack.func_190916_E());
            if (stack.func_77942_o()) {
                json.addProperty("nbt", stack.func_77978_p().toString());
            }
            return json.toString();
        }

        private static String getAsStackJson(ItemStack stack) {
            return Serializers.ITEMSTACK.write(stack).toString();
        }

        public static String getAsID(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString();
        }

        public static String getAsHolder(ItemStack stack) {
            ResourceLocation itemId = stack.func_77973_b().getRegistryName();
            return "@ObjectHolder(\"" + itemId.toString() + "\")\npublic static final Item " + itemId.func_110623_a().toUpperCase() + " = null;";
        }

        public static String getTags(ItemStack stack) {
            StringJoiner joiner = new StringJoiner("\n");
            for (ResourceLocation tag : stack.func_77973_b().getTags()) {
                joiner.add(tag.toString());
            }
            return joiner.toString();
        }

        public static String getFluids(ItemStack stack) {
            StringJoiner joiner = new StringJoiner("\n");
            LazyOptional fluidCap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            fluidCap.ifPresent(fluidHandler -> {
                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                    FluidStack fluidStack = fluidHandler.getFluidInTank(i);
                    if (fluidStack.isEmpty()) continue;
                    joiner.add(fluidStack.getRawFluid().getRegistryName().toString());
                }
            });
            return joiner.toString();
        }
    }
}

