/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.recipes.smithing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SmithingRecipeRepairCost
extends SmithingRecipe {
    public static final IRecipeSerializer<?> SERIALIZER = new Serializer();
    private final int reduction;

    public SmithingRecipeRepairCost(ResourceLocation recipeId, Ingredient base, Ingredient addition, int reduction) {
        super(recipeId, base, addition, ItemStack.field_190927_a);
        this.reduction = reduction;
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack stack = inv.func_70301_a(0).func_77946_l();
        int repairCost = Math.max(0, stack.func_82838_A() - this.reduction);
        stack.func_82841_c(repairCost);
        return stack;
    }

    public boolean func_77569_a(IInventory inv, World world) {
        return inv.func_70301_a(0).func_82838_A() > 0 && super.func_77569_a(inv, world);
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SmithingRecipeRepairCost> {
        private Serializer() {
        }

        public SmithingRecipeRepairCost read(ResourceLocation recipeId, JsonObject json) {
            Ingredient base = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"base"));
            Ingredient addition = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            int reduction = JSONUtils.func_151208_a((JsonObject)json, (String)"reduction", (int)Integer.MAX_VALUE);
            return new SmithingRecipeRepairCost(recipeId, base, addition, reduction);
        }

        public SmithingRecipeRepairCost read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient base = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient addition = Ingredient.func_199566_b((PacketBuffer)buffer);
            int reduction = buffer.readInt();
            return new SmithingRecipeRepairCost(recipeId, base, addition, reduction);
        }

        public void write(PacketBuffer buffer, SmithingRecipeRepairCost recipe) {
            recipe.field_234837_a_.func_199564_a(buffer);
            recipe.field_234838_b_.func_199564_a(buffer);
            buffer.writeInt(recipe.reduction);
        }
    }
}

