/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.recipes.smithing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.darkhax.bookshelf.serialization.Serializers;
import net.darkhax.bookshelf.util.TextUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SmithingRecipeFont
extends SmithingRecipe {
    public static final IRecipeSerializer<?> SERIALIZER = new Serializer();
    private final ResourceLocation fontId;

    public SmithingRecipeFont(ResourceLocation recipeId, Ingredient base, Ingredient addition, ResourceLocation fontId) {
        super(recipeId, base, addition, ItemStack.field_190927_a);
        this.fontId = fontId;
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack stack = inv.func_70301_a(0).func_77946_l();
        stack.func_200302_a(TextUtils.applyFont(stack.func_200301_q(), this.fontId));
        return stack;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SmithingRecipeFont> {
        private Serializer() {
        }

        public SmithingRecipeFont read(ResourceLocation recipeId, JsonObject json) {
            Ingredient base = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"base"));
            Ingredient addition = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            ResourceLocation font = Serializers.RESOURCE_LOCATION.read(json, "font");
            return new SmithingRecipeFont(recipeId, base, addition, font);
        }

        public SmithingRecipeFont read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient base = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient addition = Ingredient.func_199566_b((PacketBuffer)buffer);
            ResourceLocation font = ResourceLocation.func_208304_a((String)buffer.func_218666_n());
            return new SmithingRecipeFont(recipeId, base, addition, font);
        }

        public void write(PacketBuffer buffer, SmithingRecipeFont recipe) {
            recipe.field_234837_a_.func_199564_a(buffer);
            recipe.field_234838_b_.func_199564_a(buffer);
            buffer.func_180714_a(recipe.fontId.toString());
        }
    }
}

