/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.recipes.smithing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SmithingRecipeEnchantment
extends SmithingRecipe {
    public static final IRecipeSerializer<?> SERIALIZER = new Serializer();
    private final List<EnchantmentData> enchantments;

    public SmithingRecipeEnchantment(ResourceLocation recipeId, Ingredient base, Ingredient addition, List<EnchantmentData> enchantments) {
        super(recipeId, base, addition, ItemStack.field_190927_a);
        this.enchantments = enchantments;
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack stack = inv.func_70301_a(0).func_77946_l();
        for (EnchantmentData data : this.enchantments) {
            if (EnchantmentHelper.func_77506_a((Enchantment)data.field_76302_b, (ItemStack)stack) >= data.field_76303_c) continue;
            stack.func_77966_a(data.field_76302_b, data.field_76303_c);
        }
        return stack;
    }

    public boolean func_77569_a(IInventory inv, World world) {
        ItemStack input = inv.func_70301_a(0);
        for (EnchantmentData data : this.enchantments) {
            if (EnchantmentHelper.func_77506_a((Enchantment)data.field_76302_b, (ItemStack)input) >= data.field_76303_c) continue;
            return super.func_77569_a(inv, world);
        }
        return false;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SmithingRecipeEnchantment> {
        private Serializer() {
        }

        public SmithingRecipeEnchantment read(ResourceLocation recipeId, JsonObject json) {
            Ingredient base = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"base"));
            Ingredient addition = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            List<EnchantmentData> enchants = Serializers.ENCHANTMENT_DATA.readList(json, "enchantments");
            return new SmithingRecipeEnchantment(recipeId, base, addition, enchants);
        }

        public SmithingRecipeEnchantment read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient base = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient addition = Ingredient.func_199566_b((PacketBuffer)buffer);
            List<EnchantmentData> enchants = Serializers.ENCHANTMENT_DATA.readList(buffer);
            return new SmithingRecipeEnchantment(recipeId, base, addition, enchants);
        }

        public void write(PacketBuffer buffer, SmithingRecipeEnchantment recipe) {
            recipe.field_234837_a_.func_199564_a(buffer);
            recipe.field_234838_b_.func_199564_a(buffer);
            Serializers.ENCHANTMENT_DATA.writeList(buffer, recipe.enchantments);
        }
    }
}

