/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.world;

import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.world.ModWorldFeatures;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ModWorldgenRegistration {
    private static ConfiguredFeature<?, ?> configuredSoulstoneFeature;
    private static ConfiguredFeature<?, ?> configuredProsperityOreFeature;
    private static ConfiguredFeature<?, ?> configuredInferiumOreFeature;

    @SubscribeEvent
    public void onBiomesLoading(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        switch (category) {
            case NETHER: {
                if (!((Boolean)ModConfigs.GENERATE_SOULSTONE.get()).booleanValue()) break;
                generation.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, configuredSoulstoneFeature);
                break;
            }
            case THEEND: {
                break;
            }
            default: {
                if (((Boolean)ModConfigs.GENERATE_PROSPERITY.get()).booleanValue()) {
                    generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, configuredProsperityOreFeature);
                }
                if (!((Boolean)ModConfigs.GENERATE_INFERIUM.get()).booleanValue()) break;
                generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, configuredInferiumOreFeature);
            }
        }
    }

    public static void onCommonSetup() {
        int size = (Integer)ModConfigs.SOULSTONE_SPAWN_SIZE.get();
        int rate = (Integer)ModConfigs.SOULSTONE_SPAWN_RATE.get();
        int height = (Integer)ModConfigs.SOULSTONE_SPAWN_HEIGHT.get();
        OreFeatureConfig config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241884_c, ((Block)ModBlocks.SOULSTONE.get()).func_176223_P(), size);
        configuredSoulstoneFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)ModWorldFeatures.SOULSTONE.get()).func_225566_b_((IFeatureConfig)config).func_242733_d(height)).func_242728_a()).func_242732_c(rate);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("mysticalagriculture", "soulstone"), configuredSoulstoneFeature);
        size = (Integer)ModConfigs.PROSPERITY_SPAWN_SIZE.get();
        rate = (Integer)ModConfigs.PROSPERITY_SPAWN_RATE.get();
        height = (Integer)ModConfigs.PROSPERITY_SPAWN_HEIGHT.get();
        config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)ModBlocks.PROSPERITY_ORE.get()).func_176223_P(), size);
        configuredProsperityOreFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)config).func_242733_d(height)).func_242728_a()).func_242732_c(rate);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("mysticalagriculture", "prosperity_ore"), configuredProsperityOreFeature);
        size = (Integer)ModConfigs.INFERIUM_SPAWN_SIZE.get();
        rate = (Integer)ModConfigs.INFERIUM_SPAWN_RATE.get();
        height = (Integer)ModConfigs.INFERIUM_SPAWN_HEIGHT.get();
        config = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)ModBlocks.INFERIUM_ORE.get()).func_176223_P(), size);
        configuredInferiumOreFeature = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)config).func_242733_d(height)).func_242728_a()).func_242732_c(rate);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("mysticalagriculture", "inferium_ore"), configuredInferiumOreFeature);
    }
}

