/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugmentGetter;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.container.TinkeringTableContainer;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TinkeringTableTileEntity
extends BaseInventoryTileEntity
implements INamedContainerProvider {
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(7, () -> {
        if (this.func_145831_w() != null && !this.func_145831_w().func_201670_d()) {
            this.markDirtyAndDispatch();
        }
    });

    public TinkeringTableTileEntity() {
        super((TileEntityType)ModTileEntities.TINKERING_TABLE.get());
        this.inventory.setDefaultSlotLimit(1);
        this.inventory.setSlotValidator(this::canInsertStack);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public ITextComponent func_145748_c_() {
        return Localizable.of((String)"container.mysticalagriculture.tinkering_table").build();
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return TinkeringTableContainer.create(windowId, playerInventory, arg_0 -> ((TinkeringTableTileEntity)this).isUsableByPlayer(arg_0), (IItemHandlerModifiable)this.inventory);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    private boolean canInsertStack(int slot, ItemStack stack) {
        Item item = stack.func_77973_b();
        switch (slot) {
            case 0: {
                return item instanceof ITinkerable;
            }
            case 1: 
            case 2: {
                return item instanceof IAugmentGetter;
            }
            case 3: {
                return item == ModCrops.AIR.getEssence();
            }
            case 4: {
                return item == ModCrops.EARTH.getEssence();
            }
            case 5: {
                return item == ModCrops.WATER.getEssence();
            }
            case 6: {
                return item == ModCrops.FIRE.getEssence();
            }
        }
        return true;
    }
}

