/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.init;

import com.blakebr0.mysticalagriculture.client.screen.ReprocessorScreen;
import com.blakebr0.mysticalagriculture.client.screen.TinkeringTableScreen;
import com.blakebr0.mysticalagriculture.container.ReprocessorContainer;
import com.blakebr0.mysticalagriculture.container.TinkeringTableContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class ModContainerTypes {
    public static final List<Supplier<ContainerType<?>>> ENTRIES = new ArrayList();
    public static final RegistryObject<ContainerType<TinkeringTableContainer>> TINKERING_TABLE = ModContainerTypes.register("tinkering_table", () -> new ContainerType(TinkeringTableContainer::create));
    public static final RegistryObject<ContainerType<ReprocessorContainer>> REPROCESSOR = ModContainerTypes.register("reprocessor", () -> new ContainerType(ReprocessorContainer::create));

    @SubscribeEvent
    public void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup() {
        TINKERING_TABLE.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, TinkeringTableScreen::new));
        REPROCESSOR.ifPresent(container -> ScreenManager.func_216911_a((ContainerType)container, ReprocessorScreen::new));
    }

    private static <T extends ContainerType<?>> RegistryObject<T> register(String name, Supplier<? extends ContainerType<?>> container) {
        ResourceLocation loc = new ResourceLocation("mysticalagriculture", name);
        ENTRIES.add(() -> (ContainerType)((ContainerType)container.get()).setRegistryName(loc));
        return RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.CONTAINERS);
    }
}

