/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class CropComponentIngredient
extends Ingredient {
    private final ICrop crop;
    private final ComponentType type;
    private ItemStack[] stacks;
    private IntList stacksPacked;

    public CropComponentIngredient(ICrop crop, ComponentType type) {
        super(Stream.empty());
        this.crop = crop;
        this.type = type;
    }

    public ItemStack[] func_193365_a() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return this.stacks;
    }

    public IntList func_194139_b() {
        if (this.stacksPacked == null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            this.stacksPacked = new IntArrayList(this.stacks.length);
            for (ItemStack itemstack : this.stacks) {
                this.stacksPacked.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.stacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.stacksPacked;
    }

    public boolean test(ItemStack stack) {
        if (stack != null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            for (ItemStack itemstack : this.stacks) {
                if (itemstack.func_77973_b() != stack.func_77973_b() || itemstack.func_77952_i() != stack.func_77952_i() || !itemstack.areShareTagsEqual(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_203189_d() {
        return !(this.stacks != null && this.stacks.length != 0 || this.stacksPacked != null && !this.stacksPacked.isEmpty());
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "mysticalagriculture:crop_component");
        json.addProperty("component", this.type.name);
        json.addProperty("crop", this.crop.getId().toString());
        return json;
    }

    public boolean isSimple() {
        return Arrays.stream(this.stacks).anyMatch(ItemStack::func_77984_f);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.CROP_COMPONENT_INGREDIENT;
    }

    protected void initMatchingStacks() {
        switch (this.type) {
            case ESSENCE: {
                this.stacks = new ItemStack[]{new ItemStack((IItemProvider)this.crop.getTier().getEssence())};
                break;
            }
            case SEED: {
                this.stacks = new ItemStack[]{new ItemStack((IItemProvider)this.crop.getType().getCraftingSeed())};
                break;
            }
            case MATERIAL: {
                Ingredient material = this.crop.getCraftingMaterial();
                if (material == null) {
                    return;
                }
                this.stacks = material.func_193365_a();
            }
        }
    }

    public static enum ComponentType {
        ESSENCE("essence"),
        SEED("seed"),
        MATERIAL("material");

        public final String name;

        private ComponentType(String name) {
            this.name = name;
        }

        public static ComponentType fromName(String name) {
            return Arrays.stream(ComponentType.values()).filter(t -> t.name.equals(name)).findFirst().orElse(null);
        }
    }

    public static class Serializer
    implements IIngredientSerializer<CropComponentIngredient> {
        public CropComponentIngredient parse(PacketBuffer buffer) {
            ICrop crop = CropRegistry.getInstance().getCropById(new ResourceLocation(buffer.func_218666_n()));
            ComponentType type = ComponentType.fromName(buffer.func_218666_n());
            return new CropComponentIngredient(crop, type);
        }

        public CropComponentIngredient parse(JsonObject json) {
            String cropId = JSONUtils.func_151200_h((JsonObject)json, (String)"crop");
            String typeName = JSONUtils.func_151200_h((JsonObject)json, (String)"component");
            ICrop crop = CropRegistry.getInstance().getCropById(new ResourceLocation(cropId));
            ComponentType type = ComponentType.fromName(typeName);
            return new CropComponentIngredient(crop, type);
        }

        public void write(PacketBuffer buffer, CropComponentIngredient ingredient) {
            buffer.func_180714_a(ingredient.crop.getId().toString());
            buffer.func_180714_a(((CropComponentIngredient)ingredient).type.name);
        }
    }
}

