/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.InfusionCrafting")
@ZenRegister
public final class InfusionCrafting {
    @ZenCodeType.Method
    public static void addRecipe(final String id, final IItemStack output, final IIngredient[] inputs) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                InfusionRecipe recipe = new InfusionRecipe(new ResourceLocation("crafttweaker", id), (NonNullList<Ingredient>)InfusionCrafting.toIngredientsList(inputs), output.getInternal());
                RecipeHelper.addRecipe((IRecipe)recipe);
            }

            public String describe() {
                return "Adding Infusion Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(RecipeTypes.INFUSION, new HashMap())).values().stream().filter(r -> r.func_77571_b().func_77969_a(stack.getInternal())).map(IRecipe::func_199560_c).collect(Collectors.toList());
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(RecipeTypes.INFUSION)).remove(r));
            }

            public String describe() {
                return "Removing Infusion Crafting recipes for " + stack.getCommandString();
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }
}

