/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.lib;

import com.blakebr0.mysticalagriculture.api.tinkering.IAugment;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;

public class AbilityCache {
    private static final HashMap<String, Runnable> EMPTY_MAP = new HashMap();
    private final Map<String, Map<String, Runnable>> cache = new HashMap<String, Map<String, Runnable>>();

    public void add(IAugment augment, PlayerEntity player, Runnable onRemove) {
        String key = AbilityCache.getPlayerKey(player);
        this.cache.computeIfAbsent(augment.getId().toString(), s -> new HashMap()).put(key, onRemove);
    }

    public void remove(String augment, PlayerEntity player) {
        String key = AbilityCache.getPlayerKey(player);
        ((Runnable)((Map)this.cache.getOrDefault(augment, EMPTY_MAP)).remove(key)).run();
    }

    public boolean isCached(IAugment augment, PlayerEntity player) {
        String key = AbilityCache.getPlayerKey(player);
        return ((Map)this.cache.getOrDefault(augment.getId().toString(), EMPTY_MAP)).containsKey(key);
    }

    public Set<String> getCachedAbilities(PlayerEntity player) {
        String key = AbilityCache.getPlayerKey(player);
        return this.cache.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey(key)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static String getPlayerKey(PlayerEntity player) {
        return player.func_146103_bH().getName() + ":" + player.func_130014_f_().func_201670_d();
    }
}

