/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.IBaubleItem;
import xreliquary.util.StackHelper;
import xreliquary.util.WorldHelper;

public class InventoryHelper {
    private static final Set<BiFunction<PlayerEntity, IBaubleItem.Type, IItemHandler>> baublesItemHandlerFactories = new HashSet<BiFunction<PlayerEntity, IBaubleItem.Type, IItemHandler>>();

    private InventoryHelper() {
    }

    public static void addBaublesItemHandlerFactory(BiFunction<PlayerEntity, IBaubleItem.Type, IItemHandler> factory) {
        baublesItemHandlerFactories.add(factory);
    }

    public static void spawnItemStack(World world, BlockPos pos, ItemStack stack) {
        net.minecraft.inventory.InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
    }

    public static ItemStack getTargetItem(ItemStack self, IItemHandler inventory) {
        if (self.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack targetItem = ItemStack.field_190927_a;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (StackHelper.isItemAndNbtEqual(self, stack) || stack.func_77976_d() == 1 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
        }
        return targetItem;
    }

    public static int getItemQuantity(ItemStack stack, IItemHandler inventory) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack newStack = inventory.getStackInSlot(slot);
            if (!StackHelper.isItemAndNbtEqual(stack, newStack)) continue;
            itemQuantity += newStack.func_190916_E();
        }
        return itemQuantity;
    }

    public static boolean consumeItem(Predicate<ItemStack> itemMatches, PlayerEntity player) {
        return !InventoryHelper.consumeItemStack(itemMatches, player).func_190926_b();
    }

    public static ItemStack consumeItemStack(Predicate<ItemStack> itemMatches, PlayerEntity player) {
        ItemStack ret = ItemStack.field_190927_a;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            int stackSize;
            ItemStack slotStack;
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || !itemMatches.test(slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot)) || (stackSize = slotStack.func_190916_E()) <= 0) continue;
            ret = ItemHandlerHelper.copyStackWithSize((ItemStack)slotStack, (int)1);
            slotStack.func_190918_g(1);
            if (slotStack.func_190916_E() <= 0) {
                player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
            }
            return ret;
        }
        return ret;
    }

    public static boolean consumeItem(ItemStack item, PlayerEntity player) {
        return InventoryHelper.consumeItem(item, player, 0, 1);
    }

    public static boolean consumeItem(ItemStack item, PlayerEntity player, int minCount) {
        return InventoryHelper.consumeItem(item, player, minCount, 1);
    }

    public static boolean consumeItem(ItemStack itemStack, PlayerEntity player, int minCount, int countToConsume) {
        if (player.func_184812_l_()) {
            return true;
        }
        if (itemStack.func_190926_b() || countToConsume <= 0) {
            return false;
        }
        int itemCount = 0;
        ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> slotCounts = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            ItemStack slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
            if (!StackHelper.isItemAndNbtEqual(slotStack, itemStack)) continue;
            int n = slotStack.func_190916_E();
            itemCount += n;
            slotCounts.add(new AbstractMap.SimpleEntry<Integer, Integer>(slot, n));
        }
        if (itemCount - countToConsume < minCount) {
            return false;
        }
        if (itemCount >= countToConsume) {
            slotCounts.sort((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()));
            int countToFill = itemCount - countToConsume;
            for (Map.Entry entry : slotCounts) {
                int slot = (Integer)entry.getKey();
                if (countToFill > 0) {
                    int stackSizeToFill = Math.min(itemStack.func_77976_d(), countToFill);
                    player.field_71071_by.func_70301_a(slot).func_190920_e(stackSizeToFill);
                    countToFill -= stackSizeToFill;
                    continue;
                }
                player.field_71071_by.func_70298_a(slot, player.field_71071_by.func_70301_a(slot).func_190916_E());
            }
            return true;
        }
        return false;
    }

    public static int tryToRemoveFromInventory(ItemStack contents, IItemHandler inventory, int maxToRemove) {
        int remaining = maxToRemove;
        ItemStack stackToExtract = contents.func_77946_l();
        int currentStackCount = Math.min(remaining, stackToExtract.func_77976_d());
        stackToExtract.func_190920_e(currentStackCount);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack extractedStack;
            if (inventory.getStackInSlot(slot).func_190926_b()) continue;
            while (inventory.getStackInSlot(slot).func_190916_E() > 0 && StackHelper.isItemAndNbtEqual(inventory.getStackInSlot(slot), contents) && remaining > 0 && (extractedStack = inventory.extractItem(slot, Math.min(maxToRemove, inventory.getStackInSlot(slot).func_190916_E()), false)).func_190916_E() != 0) {
                stackToExtract = contents.func_77946_l();
                currentStackCount = Math.min(remaining -= extractedStack.func_190916_E(), stackToExtract.func_77976_d());
                stackToExtract.func_190920_e(currentStackCount);
            }
            if (remaining <= 0) break;
        }
        return maxToRemove - remaining;
    }

    public static LazyOptional<IItemHandler> getInventoryAtPos(World world, BlockPos pos) {
        return InventoryHelper.getInventoryAtPos(world, pos, null);
    }

    public static LazyOptional<IItemHandler> getInventoryAtPos(World world, BlockPos pos, @Nullable Direction side) {
        return WorldHelper.getTile((IBlockReader)world, pos).map(te -> InventoryHelper.getItemHandlerFrom(te, side)).orElse(LazyOptional.empty());
    }

    public static LazyOptional<IItemHandler> getItemHandlerFrom(PlayerEntity player, @Nullable Direction side) {
        return player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static LazyOptional<IItemHandler> getItemHandlerFrom(PlayerEntity player) {
        return InventoryHelper.getItemHandlerFrom(player, Direction.UP);
    }

    public static LazyOptional<IItemHandler> getItemHandlerFrom(TileEntity te) {
        return InventoryHelper.getItemHandlerFrom(te, null);
    }

    private static LazyOptional<IItemHandler> getItemHandlerFrom(TileEntity te, @Nullable Direction side) {
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static int insertIntoInventory(ItemStack contents, IItemHandler inventory) {
        return InventoryHelper.tryToAddToInventory(contents, inventory, contents.func_190916_E());
    }

    public static int tryToAddToInventory(ItemStack contents, IItemHandler inventory, int maxToAdd) {
        int inventorySize = inventory.getSlots();
        int remaining = maxToAdd;
        ItemStack stackToInsert = contents.func_77946_l();
        int currentStackCount = Math.min(remaining, stackToInsert.func_77976_d());
        stackToInsert.func_190920_e(currentStackCount);
        for (int slot = 0; slot < inventorySize; ++slot) {
            while (inventory.insertItem(slot, stackToInsert, true).func_190916_E() < stackToInsert.func_190916_E()) {
                ItemStack remainingStack = inventory.insertItem(slot, stackToInsert, false);
                if (remainingStack.func_190916_E() >= currentStackCount) continue;
                if ((remaining -= currentStackCount - remainingStack.func_190916_E()) <= 0) {
                    return maxToAdd;
                }
                stackToInsert = contents.func_77946_l();
                currentStackCount = Math.min(remaining, stackToInsert.func_77976_d());
                stackToInsert.func_190920_e(currentStackCount);
            }
        }
        return maxToAdd - remaining;
    }

    public static void tryRemovingLastStack(IItemHandler inventory, World world, BlockPos pos) {
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            if (inventory.getStackInSlot(i).func_190926_b()) continue;
            ItemStack stack = inventory.getStackInSlot(i).func_77946_l();
            inventory.extractItem(i, stack.func_190916_E(), false);
            if (world.field_72995_K) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, stack);
            world.func_217376_c((Entity)itemEntity);
            break;
        }
    }

    public static boolean tryAddingPlayerCurrentItem(PlayerEntity player, IItemHandler inventory, Hand hand) {
        ItemStack stack = player.func_184586_b(hand).func_77946_l();
        stack.func_190920_e(1);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack remainingStack = inventory.insertItem(slot, stack, false);
            if (!remainingStack.func_190926_b()) continue;
            player.func_184586_b(hand).func_190918_g(1);
            if (player.func_184586_b(hand).func_190916_E() == 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    public static boolean playerHasItem(PlayerEntity player, Item item) {
        return InventoryHelper.playerHasItem(player, item, false, IBaubleItem.Type.NONE);
    }

    public static boolean playerHasItem(PlayerEntity player, Item item, boolean checkEnabled, IBaubleItem.Type baubleType) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != item || checkEnabled && stack.func_77973_b() instanceof ToggleableItem && !((ToggleableItem)stack.func_77973_b()).isEnabled(stack)) continue;
            return true;
        }
        return baubleType != IBaubleItem.Type.NONE && InventoryHelper.hasItemInBaubleInventories(player, item, checkEnabled, baubleType);
    }

    private static boolean hasItemInBaubleInventories(PlayerEntity player, Item item, boolean checkEnabled, IBaubleItem.Type baubleType) {
        for (BiFunction<PlayerEntity, IBaubleItem.Type, IItemHandler> factory : baublesItemHandlerFactories) {
            IItemHandler handler = factory.apply(player, baubleType);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack baubleStack = handler.getStackInSlot(i);
                if (baubleStack.func_190926_b() || baubleStack.func_77973_b() != item || checkEnabled && baubleStack.func_77973_b() instanceof ToggleableItem && !((ToggleableItem)baubleStack.func_77973_b()).isEnabled(baubleStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getCorrectItemFromEitherHand(PlayerEntity player, Item item) {
        return InventoryHelper.getHandHoldingCorrectItem(player, item).map(arg_0 -> ((PlayerEntity)player).func_184586_b(arg_0)).orElse(ItemStack.field_190927_a);
    }

    private static Optional<Hand> getHandHoldingCorrectItem(PlayerEntity player, Item item) {
        if (player.func_184614_ca().func_77973_b() == item) {
            return Optional.of(Hand.MAIN_HAND);
        }
        if (player.func_184592_cb().func_77973_b() == item) {
            return Optional.of(Hand.OFF_HAND);
        }
        return Optional.empty();
    }

    public static void addItemToPlayerInventory(PlayerEntity player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            player.field_71071_by.func_70299_a(i, stack);
            return;
        }
        player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack));
    }

    public static NonNullList<ItemStack> getItemStacks(IItemHandler inventory) {
        NonNullList ret = NonNullList.func_191196_a();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ret.add((Object)inventory.getStackInSlot(slot));
        }
        return ret;
    }

    public static void dropInventoryItems(World world, BlockPos pos, IItemHandler inventory) {
        InventoryHelper.dropInventoryItems(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), inventory);
    }

    private static void dropInventoryItems(World world, double x, double y, double z, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            net.minecraft.inventory.InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)itemstack);
        }
    }

    public static boolean hasItemHandler(World world, BlockPos pos) {
        return WorldHelper.getTile((IBlockReader)world, pos).map(InventoryHelper::hasItemHandler).orElse(false);
    }

    private static boolean hasItemHandler(TileEntity te) {
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent();
    }

    public static <T extends IItemHandler> void runOnItemHandler(ItemStack stack, Consumer<T> run, Class<T> itemHandlerClass) {
        InventoryHelper.getItemHandler(stack, itemHandlerClass).ifPresent(run);
    }

    private static <T extends IItemHandler> Optional<T> getItemHandler(ItemStack stack, Class<T> itemHandlerClass) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).filter(itemHandlerClass::isInstance).map(itemHandlerClass::cast);
    }

    public static <R, T extends IItemHandler> Optional<R> getFromHandler(ItemStack stack, Function<T, R> get, Class<T> itemHandlerClass) {
        return InventoryHelper.getItemHandler(stack, itemHandlerClass).map(get);
    }
}

