/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.blocks.FertileLilyPadBlock;
import xreliquary.init.ModItems;
import xreliquary.items.HarvestRodItem;
import xreliquary.reference.Settings;
import xreliquary.util.ItemHelper;

public class PedestalHarvestRodWrapper
implements IPedestalActionItemWrapper {
    private static final int NO_JOB_COOL_DOWN_CYCLES = 10;
    private static final HarvestRodItem harvestRod = ModItems.HARVEST_ROD;
    private int hoeCoolDown = 0;
    private int plantCoolDown = 0;
    private int boneMealCoolDown = 0;
    private int breakCoolDown = 0;
    private final Queue<BlockPos> queueToHoe = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToPlant = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToBoneMeal = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToBreak = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        FakePlayer player = pedestal.getFakePlayer();
        int range = (Integer)Settings.COMMON.items.harvestRod.pedestalRange.get();
        int cooldown = (Integer)Settings.COMMON.items.harvestRod.pedestalCooldown.get();
        this.hoeLand(world, (PlayerEntity)player, pos, range);
        this.plantSeeds(world, (PlayerEntity)player, pos, stack, range);
        this.boneMealCrops(world, pos, stack, range);
        this.breakCrops(world, (PlayerEntity)player, pos, stack, range);
        pedestal.setActionCoolDown(cooldown);
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
        if (!pedestal.getTheWorld().field_72995_K) {
            harvestRod.updateContainedStacks(stack);
        }
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    private void breakCrops(World world, PlayerEntity player, BlockPos pos, ItemStack stack, int range) {
        if (this.breakCoolDown > 0) {
            --this.breakCoolDown;
        } else if (!this.breakNext(world, player, pos, stack, range)) {
            this.breakCoolDown = 10;
        }
    }

    private boolean breakNext(World world, PlayerEntity player, BlockPos pos, ItemStack stack, int range) {
        return this.getNextBlockToBreak(world, pos, range).map(nextBlockToBreak -> {
            this.doHarvestBlockBreak(world, player, stack, (BlockPos)nextBlockToBreak);
            return true;
        }).orElse(false);
    }

    private void doHarvestBlockBreak(World world, PlayerEntity player, ItemStack stack, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        List drops = Block.func_220077_a((BlockState)blockState, (ServerWorld)((ServerWorld)world), (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
        for (ItemStack drop : drops) {
            float f = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityitem = new ItemEntity(world, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drop);
            entityitem.func_174867_a(10);
            world.func_217376_c((Entity)entityitem);
        }
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    private void boneMealCrops(World world, BlockPos pos, ItemStack stack, int range) {
        if (this.boneMealCoolDown > 0) {
            --this.boneMealCoolDown;
        } else {
            if (harvestRod.getBoneMealCount(stack) >= harvestRod.getBonemealCost() && this.boneMealNext(world, pos, stack, range)) {
                return;
            }
            this.boneMealCoolDown = 10;
        }
    }

    private boolean boneMealNext(World world, BlockPos pos, ItemStack stack, int range) {
        return this.getNextBlockToBoneMeal(world, pos, range).map(blockToBoneMeal -> {
            this.boneMealBlock(stack, world, (BlockPos)blockToBoneMeal);
            return true;
        }).orElse(false);
    }

    private void boneMealBlock(ItemStack stack, World world, BlockPos pos) {
        ItemStack fakeItemStack = new ItemStack((IItemProvider)Items.field_196106_bc);
        boolean boneMealUsed = false;
        for (int repeatedUses = 0; repeatedUses <= harvestRod.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && world.field_73012_v.nextInt(100) > harvestRod.getLuckPercent() || !BoneMealItem.func_195966_a((ItemStack)fakeItemStack, (World)world, (BlockPos)pos)) continue;
            boneMealUsed = true;
        }
        if (boneMealUsed) {
            world.func_217379_c(2005, pos, 0);
            harvestRod.setBoneMealCount(stack, harvestRod.getBoneMealCount(stack) - harvestRod.getBonemealCost());
        }
    }

    private void plantSeeds(World world, PlayerEntity player, BlockPos pos, ItemStack stack, int range) {
        if (this.plantCoolDown > 0) {
            --this.plantCoolDown;
        } else {
            int quantity;
            byte plantableSlot = 1;
            if (harvestRod.getCountPlantable(stack) > 0 && (quantity = harvestRod.getPlantableQuantity(stack, plantableSlot)) > 0 && this.plantNext(world, player, pos, stack, range, plantableSlot)) {
                return;
            }
            this.plantCoolDown = 10;
        }
    }

    private boolean plantNext(World world, PlayerEntity player, BlockPos pos, ItemStack stack, int range, byte plantableSlot) {
        return this.getNextBlockToPlantOn(world, pos, range, (IPlantable)((BlockItem)harvestRod.getPlantableInSlot(stack, plantableSlot).func_77973_b()).func_179223_d()).map(blockToPlantOn -> {
            this.plantItem(player, (BlockPos)blockToPlantOn, stack, plantableSlot);
            return true;
        }).orElse(false);
    }

    private void plantItem(PlayerEntity player, BlockPos pos, ItemStack stack, byte idx) {
        ItemStack fakePlantableStack = harvestRod.getPlantableInSlot(stack, idx).func_77946_l();
        fakePlantableStack.func_190920_e(1);
        player.func_184611_a(Hand.MAIN_HAND, fakePlantableStack);
        if (fakePlantableStack.func_196084_a(ItemHelper.getItemUseContext(pos, player)) == ActionResultType.SUCCESS) {
            harvestRod.setPlantableQuantity(stack, idx, harvestRod.getPlantableQuantity(stack, idx) - 1);
        }
    }

    private void hoeLand(World world, PlayerEntity player, BlockPos pos, int range) {
        if (this.hoeCoolDown > 0) {
            --this.hoeCoolDown;
        } else if (!this.hoeNext(world, player, pos, range)) {
            this.hoeCoolDown = 10;
        }
    }

    private boolean hoeNext(World world, PlayerEntity player, BlockPos pos, int range) {
        return this.getNextBlockToHoe(world, pos, range).map(blockToHoe -> {
            ItemStack fakeHoe = new ItemStack((IItemProvider)Items.field_151017_I);
            player.func_184611_a(Hand.MAIN_HAND, fakeHoe);
            Items.field_151017_I.func_195939_a(ItemHelper.getItemUseContext(blockToHoe, player));
            return true;
        }).orElse(false);
    }

    private Optional<BlockPos> getNextBlockToBreak(World world, BlockPos pos, int range) {
        if (this.queueToBreak.isEmpty()) {
            this.fillQueueToBreak(world, pos, range);
        }
        return Optional.ofNullable(this.queueToBreak.poll());
    }

    private void fillQueueToBreak(World world, BlockPos pos, int range) {
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.func_185334_h();
            BlockState state = world.func_180495_p(currentPos);
            Block block = state.func_177230_c();
            if (block instanceof IPlantable || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK) {
                if (block instanceof FertileLilyPadBlock || block == Blocks.field_150393_bb || block == Blocks.field_150394_bc || block instanceof CropsBlock && ((CropsBlock)block).func_176473_a((IBlockReader)world, currentPos, state, false) || block instanceof NetherWartBlock && (Integer)state.func_177229_b((Property)NetherWartBlock.field_176486_a) < 3) {
                    return;
                }
                this.queueToBreak.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToHoe(World world, BlockPos pos, int range) {
        if (this.queueToHoe.isEmpty()) {
            this.fillQueueToHoe(world, pos, range);
        }
        return Optional.ofNullable(this.queueToHoe.poll());
    }

    private void fillQueueToHoe(World world, BlockPos pos, int range) {
        this.queueToHoe.clear();
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.func_185334_h();
            BlockState blockState = world.func_180495_p(currentPos);
            Block block = blockState.func_177230_c();
            if (world.func_175623_d(currentPos.func_177984_a()) && (block == Blocks.field_196658_i || block == Blocks.field_185774_da || block == Blocks.field_150346_d || block == Blocks.field_196660_k)) {
                this.queueToHoe.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToPlantOn(World world, BlockPos pos, int range, IPlantable plantable) {
        if (this.queueToPlant.isEmpty()) {
            this.fillQueueToPlant(world, pos, range, plantable);
        }
        return Optional.ofNullable(this.queueToPlant.poll());
    }

    private void fillQueueToPlant(World world, BlockPos pos, int range, IPlantable plantable) {
        this.queueToPlant.clear();
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable == Items.field_151080_bb || plantable == Items.field_151081_bc) {
            checkerboard = true;
            boolean xEven = pos.func_177958_n() % 2 == 0;
            boolean zEven = pos.func_177952_p() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        boolean finalCheckerboard = checkerboard;
        boolean finalBothOddOrEven = bothOddOrEven;
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.func_185334_h();
            BlockState blockState = world.func_180495_p(currentPos);
            if ((!finalCheckerboard || finalBothOddOrEven == (currentPos.func_177958_n() % 2 == 0 == (currentPos.func_177952_p() % 2 == 0))) && blockState.func_177230_c().canSustainPlant(blockState, (IBlockReader)world, pos, Direction.UP, plantable) && world.func_175623_d(currentPos.func_177984_a())) {
                this.queueToPlant.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToBoneMeal(World world, BlockPos pos, int range) {
        if (this.queueToBoneMeal.isEmpty()) {
            this.fillQueueToBoneMeal(world, pos, range);
        }
        return Optional.ofNullable(this.queueToBoneMeal.poll());
    }

    private void fillQueueToBoneMeal(World world, BlockPos pos, int range) {
        this.queueToBoneMeal.clear();
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.func_185334_h();
            BlockState blockState = world.func_180495_p(currentPos);
            if (blockState.func_177230_c() != Blocks.field_196658_i && blockState.func_177230_c() instanceof IGrowable && ((IGrowable)blockState.func_177230_c()).func_176473_a((IBlockReader)world, currentPos, blockState, world.field_72995_K)) {
                this.queueToBoneMeal.add(currentPos);
            }
        });
    }
}

