/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketFXThrownPotionImpact {
    private final int color;
    private final double posX;
    private final double posY;
    private final double posZ;

    public PacketFXThrownPotionImpact(int color, double x, double y, double z) {
        this.color = color;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    static void encode(PacketFXThrownPotionImpact msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.color);
        packetBuffer.writeDouble(msg.posX);
        packetBuffer.writeDouble(msg.posY);
        packetBuffer.writeDouble(msg.posZ);
    }

    static PacketFXThrownPotionImpact decode(PacketBuffer packetBuffer) {
        return new PacketFXThrownPotionImpact(packetBuffer.readInt(), packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
    }

    static void onMessage(PacketFXThrownPotionImpact msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketFXThrownPotionImpact.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(PacketFXThrownPotionImpact message) {
        Minecraft mc = Minecraft.func_71410_x();
        int color = message.color;
        Random rand = mc.field_71441_e.field_73012_v;
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color & 0xFF) / 256.0f;
        for (int i = 0; i < 100; ++i) {
            double var39 = rand.nextDouble() * 4.0;
            double angle = rand.nextDouble() * Math.PI * 2.0;
            double xSpeed = Math.cos(angle) * var39;
            double ySpeed = 0.01 + rand.nextDouble() * 0.5;
            double zSpeed = Math.sin(angle) * var39;
            Particle particle = mc.field_71452_i.func_199280_a((IParticleData)ParticleTypes.field_197620_m, message.posX + xSpeed * 0.1, message.posY + 0.3, message.posZ + zSpeed * 0.1, xSpeed, ySpeed, zSpeed);
            if (particle == null) continue;
            float var32 = 0.75f + rand.nextFloat() * 0.25f;
            particle.func_70538_b(red * var32, green * var32, blue * var32);
            particle.func_70543_e((float)var39);
        }
    }
}

