/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.ILeftClickableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.NoPlayerBlockItemUseContext;

public class SojournerStaffItem
extends ToggleableItem
implements ILeftClickableItem {
    private static final String ITEMS_TAG = "Items";
    private static final String QUANTITY_TAG = "Quantity";
    private static final String CURRENT_INDEX_TAG = "Current";

    public SojournerStaffItem() {
        super("sojourner_staff", new Item.Properties().func_200917_a(1));
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        PlayerEntity player = null;
        if (entity instanceof PlayerEntity) {
            player = (PlayerEntity)entity;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(stack)) {
            this.scanForMatchingTorchesToFillInternalStorage(stack, player);
        }
    }

    @Override
    public ActionResultType onLeftClickItem(ItemStack stack, LivingEntity entityLiving) {
        if (!entityLiving.func_225608_bj_()) {
            return ActionResultType.CONSUME;
        }
        if (entityLiving.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        this.cycleTorchMode(stack);
        return ActionResultType.SUCCESS;
    }

    private void scanForMatchingTorchesToFillInternalStorage(ItemStack stack, PlayerEntity player) {
        for (String torch : (List)Settings.COMMON.items.sojournerStaff.torches.get()) {
            ItemStack consumedStack;
            if (this.isInternalStorageFullOfItem(stack, torch) || (consumedStack = InventoryHelper.consumeItemStack(is -> is.func_77973_b().getRegistryName() != null && is.func_77973_b().getRegistryName().toString().equals(torch), player)).func_190926_b()) continue;
            this.addItemToInternalStorage(stack, consumedStack);
        }
    }

    private void addItemToInternalStorage(ItemStack stack, ItemStack torchItem) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        boolean added = false;
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            ItemStack item = SojournerStaffItem.getItem(tagItemData);
            if (item.func_77973_b() != torchItem.func_77973_b()) continue;
            int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            tagItemData.func_74768_a(QUANTITY_TAG, quantity + 1);
            added = true;
        }
        if (!added) {
            CompoundNBT newTagData = new CompoundNBT();
            newTagData.func_218657_a("Item", (INBT)torchItem.func_77955_b(new CompoundNBT()));
            newTagData.func_74768_a(QUANTITY_TAG, 1);
            tagList.add((Object)newTagData);
        }
        tagCompound.func_218657_a(ITEMS_TAG, (INBT)tagList);
        stack.func_77982_d(tagCompound);
    }

    private static boolean hasItemInInternalStorage(ItemStack stack, String itemRegistryName, int cost) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        if (tagCompound.isEmpty()) {
            tagCompound.func_218657_a(ITEMS_TAG, (INBT)new ListNBT());
            return false;
        }
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            if (!SojournerStaffItem.getItem(tagItemData).func_77973_b().getRegistryName().toString().equals(itemRegistryName)) continue;
            int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            return quantity >= cost;
        }
        return false;
    }

    private boolean isInternalStorageFullOfItem(ItemStack stack, String itemRegistryName) {
        if (SojournerStaffItem.hasItemInInternalStorage(stack, itemRegistryName, 1)) {
            CompoundNBT tagCompound = NBTHelper.getTag(stack);
            ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tagItemData = tagList.func_150305_b(i);
                if (!SojournerStaffItem.getItem(tagItemData).func_77973_b().getRegistryName().toString().equals(itemRegistryName)) continue;
                int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
                return quantity >= this.getTorchItemMaxCapacity();
            }
        }
        return false;
    }

    public ItemStack getCurrentTorch(ItemStack stack) {
        return SojournerStaffItem.getItem(this.getCurrentTorchTag(stack));
    }

    public int getTorchCount(ItemStack stack) {
        return this.getCurrentTorchTag(stack).func_74762_e(QUANTITY_TAG);
    }

    private CompoundNBT getCurrentTorchTag(ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        int current = this.getCurrentIndex(tagCompound, tagList);
        return tagList.func_150305_b(current);
    }

    private void cycleTorchMode(ItemStack stack) {
        int quantity;
        CompoundNBT tagItemData;
        int i;
        ItemStack currentTorch = this.getCurrentTorch(stack);
        if (currentTorch.func_190926_b()) {
            return;
        }
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        if (tagList.size() == 1) {
            return;
        }
        int current = this.getCurrentIndex(tagCompound, tagList);
        for (i = current + 1; i < tagList.size(); ++i) {
            tagItemData = tagList.func_150305_b(i);
            quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            if (quantity <= 0) continue;
            tagCompound.func_74768_a(CURRENT_INDEX_TAG, i);
            return;
        }
        for (i = 0; i <= current; ++i) {
            tagItemData = tagList.func_150305_b(i);
            quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            if (quantity <= 0) continue;
            tagCompound.func_74768_a(CURRENT_INDEX_TAG, i);
            return;
        }
    }

    private int getCurrentIndex(CompoundNBT tagCompound, ListNBT tagList) {
        int current = tagCompound.func_74762_e(CURRENT_INDEX_TAG);
        if (tagList.size() <= current) {
            tagCompound.func_74768_a(CURRENT_INDEX_TAG, 0);
        }
        return current;
    }

    private int getTorchItemMaxCapacity() {
        return (Integer)Settings.COMMON.items.sojournerStaff.maxCapacityPerItemType.get();
    }

    static boolean removeItemFromInternalStorage(ItemStack stack, String itemRegistryName, int cost, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        if (SojournerStaffItem.hasItemInInternalStorage(stack, itemRegistryName, cost)) {
            CompoundNBT tagCompound = NBTHelper.getTag(stack);
            ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
            ListNBT replacementTagList = new ListNBT();
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT tagItemData = tagList.func_150305_b(i);
                String itemName = SojournerStaffItem.getItem(tagItemData).func_77973_b().getRegistryName().toString();
                if (itemName.equals(itemRegistryName)) {
                    int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
                    tagItemData.func_74768_a(QUANTITY_TAG, quantity - cost);
                }
                replacementTagList.add((Object)tagItemData);
            }
            tagCompound.func_218657_a(ITEMS_TAG, (INBT)replacementTagList);
            stack.func_77982_d(tagCompound);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack staff, @Nullable World world, List<ITextComponent> tooltip) {
        String phrase = "Nothing.";
        CompoundNBT tagCompound = NBTHelper.getTag(staff);
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagItemData = tagList.func_150305_b(i);
            ItemStack containedItem = SojournerStaffItem.getItem(tagItemData);
            int quantity = tagItemData.func_74762_e(QUANTITY_TAG);
            phrase = String.format("%s%s", phrase.equals("Nothing.") ? "" : String.format("%s;", phrase), containedItem.func_200301_q().getString() + ": " + quantity);
        }
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"placing", (Object)this.getCurrentTorch(staff).func_200301_q().getString()), tooltip);
        if (this.isEnabled(staff)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + new ItemStack((IItemProvider)Blocks.field_150478_aa).func_200301_q().getString())), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private static ItemStack getItem(CompoundNBT tagItemData) {
        return ItemStack.func_199557_a((CompoundNBT)tagItemData.func_74775_l("Item"));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return this.placeTorch(context);
    }

    private ActionResultType placeTorch(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction face = context.func_196000_l();
        ItemStack stack = context.func_195996_i();
        BlockPos placeBlockAt = pos.func_177972_a(face);
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack torch = this.getCurrentTorch(stack);
        if (player == null || torch.func_190926_b() || !(torch.func_77973_b() instanceof BlockItem)) {
            return ActionResultType.FAIL;
        }
        if (!player.func_175151_a(placeBlockAt, face, stack) || player.func_213453_ef()) {
            return ActionResultType.PASS;
        }
        player.func_184609_a(hand);
        Block blockToPlace = ((BlockItem)torch.func_77973_b()).func_179223_d();
        NoPlayerBlockItemUseContext placeContext = new NoPlayerBlockItemUseContext(world, placeBlockAt, new ItemStack((IItemProvider)blockToPlace), face);
        if (!placeContext.func_196011_b() || !this.removeTorches(player, stack, blockToPlace, placeBlockAt)) {
            return ActionResultType.FAIL;
        }
        ((BlockItem)torch.func_77973_b()).func_195942_a((BlockItemUseContext)placeContext);
        double gauss = 0.5 + (double)(world.field_73012_v.nextFloat() / 2.0f);
        world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)placeBlockAt.func_177958_n() + 0.5, (double)placeBlockAt.func_177956_o() + 0.5, (double)placeBlockAt.func_177952_p() + 0.5, gauss, gauss, 0.0);
        return ActionResultType.SUCCESS;
    }

    private boolean removeTorches(PlayerEntity player, ItemStack stack, Block blockToPlace, BlockPos placeBlockAt) {
        if (!player.func_184812_l_()) {
            int distance = (int)player.func_174824_e(1.0f).func_72438_d(new Vector3d((double)placeBlockAt.func_177958_n(), (double)placeBlockAt.func_177956_o(), (double)placeBlockAt.func_177952_p()));
            int cost = 1 + distance / (Integer)Settings.COMMON.items.sojournerStaff.tilePerCostMultiplier.get();
            return SojournerStaffItem.removeItemFromInternalStorage(stack, blockToPlace.getRegistryName().toString(), cost, player);
        }
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        RayTraceResult rayTraceResult;
        if (!player.func_225608_bj_() && (rayTraceResult = this.longRayTrace(world, player)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.placeTorch(new ItemUseContext(player, hand, (BlockRayTraceResult)rayTraceResult));
        }
        return super.func_77659_a(world, player, hand);
    }

    private RayTraceResult longRayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = ((Integer)Settings.COMMON.items.sojournerStaff.maxRange.get()).intValue();
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)player));
    }
}

