/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.UseAction;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import xreliquary.Reliquary;
import xreliquary.util.LanguageHelper;
import xreliquary.util.RandHelper;

public class ShearsOfWinterItem
extends ShearsItem {
    public ShearsOfWinterItem() {
        super(new Item.Properties().func_200916_a(Reliquary.ITEM_GROUP).func_200918_c(0));
        this.setRegistryName(new ResourceLocation("xreliquary", "shears_of_winter"));
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 2500;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (this.func_77626_a(stack) - count <= 5 || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Vector3d lookVector = player.func_70040_Z();
        this.spawnBlizzardParticles(lookVector, player);
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.doEntityShearableCheck(stack, player, lookVector);
        this.shearBlocks(player, lookVector);
    }

    private void shearBlocks(PlayerEntity player, Vector3d lookVector) {
        BlockPos firstPos = new BlockPos(player.func_174824_e(1.0f));
        BlockPos secondPos = new BlockPos(player.func_174824_e(1.0f).func_178787_e(lookVector.func_216372_d(10.0, 10.0, 10.0)));
        if (firstPos.func_177958_n() == secondPos.func_177958_n()) {
            firstPos = firstPos.func_177982_a(-2, 0, 0);
            secondPos = secondPos.func_177982_a(2, 0, 0);
        }
        if (firstPos.func_177956_o() == secondPos.func_177956_o()) {
            firstPos = firstPos.func_177982_a(0, -2, 0);
            secondPos = secondPos.func_177982_a(0, 2, 0);
        }
        if (firstPos.func_177952_p() == secondPos.func_177952_p()) {
            firstPos = firstPos.func_177982_a(0, 0, -2);
            secondPos = secondPos.func_177982_a(0, 0, 2);
        }
        BlockPos.func_218281_b((BlockPos)firstPos, (BlockPos)secondPos).forEach(pos -> this.checkAndBreakBlockAt(player, (BlockPos)pos));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack shears, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip", null, tooltip);
    }

    private void checkAndBreakBlockAt(PlayerEntity player, BlockPos pos) {
        int distance = (int)Math.sqrt(pos.func_218140_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), false));
        int probabilityFactor = 5 + distance;
        if (player.field_70170_p.field_73012_v.nextInt(probabilityFactor) == 0) {
            this.shearBlockAt(pos, player);
        }
    }

    private void shearBlockAt(BlockPos pos, PlayerEntity player) {
        ItemStack dummyShears;
        IForgeShearable target;
        World world = player.field_70170_p;
        BlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof IForgeShearable && (target = (IForgeShearable)block).isShearable(dummyShears = new ItemStack((IItemProvider)Items.field_151097_aZ), world, pos) && this.removeBlock(player, pos, blockState.canHarvestBlock((IBlockReader)world, pos, player))) {
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)block));
            player.func_71020_j(0.01f);
            Block.func_220054_a((BlockState)blockState, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)dummyShears);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity) {
            this.shearBlockAt(pos, (PlayerEntity)entityLiving);
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    private boolean removeBlock(PlayerEntity player, BlockPos pos, boolean canHarvest) {
        BlockState state = player.field_70170_p.func_180495_p(pos);
        boolean removed = state.removedByPlayer(player.field_70170_p, pos, player, canHarvest, player.field_70170_p.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)player.field_70170_p, pos, state);
        }
        return removed;
    }

    private void doEntityShearableCheck(ItemStack stack, PlayerEntity player, Vector3d lookVector) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        double lowerX = Math.min(player.func_226277_ct_(), player.func_226277_ct_() + lookVector.field_72450_a * 10.0);
        double lowerY = Math.min(player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226278_cu_() + (double)player.func_70047_e() + lookVector.field_72448_b * 10.0);
        double lowerZ = Math.min(player.func_226281_cx_(), player.func_226281_cx_() + lookVector.field_72449_c * 10.0);
        double upperX = Math.max(player.func_226277_ct_(), player.func_226277_ct_() + lookVector.field_72450_a * 10.0);
        double upperY = Math.max(player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226278_cu_() + (double)player.func_70047_e() + lookVector.field_72448_b * 10.0);
        double upperZ = Math.max(player.func_226281_cx_(), player.func_226281_cx_() + lookVector.field_72449_c * 10.0);
        List eList = player.field_70170_p.func_217357_a(MobEntity.class, new AxisAlignedBB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ));
        Random rand = player.field_70170_p.field_73012_v;
        for (MobEntity e : eList) {
            int distance = (int)player.func_70032_d((Entity)e);
            int probabilityFactor = (distance - 3) / 2;
            if (probabilityFactor > 0 && player.field_70170_p.field_73012_v.nextInt(probabilityFactor) != 0) continue;
            if (!e.func_70028_i((Entity)player)) {
                e.func_195064_c(new EffectInstance(Effects.field_76421_d, 120, 1));
            }
            if (!(e instanceof IForgeShearable)) continue;
            this.shearEntity(stack, player, rand, e);
        }
    }

    private void shearEntity(ItemStack stack, PlayerEntity player, Random rand, MobEntity e) {
        IForgeShearable target = (IForgeShearable)e;
        BlockPos pos = new BlockPos((int)e.func_226277_ct_(), (int)e.func_226278_cu_(), (int)e.func_226281_cx_());
        if (target.isShearable(new ItemStack((IItemProvider)Items.field_151097_aZ), e.field_70170_p, pos)) {
            List drops = target.onSheared(player, stack, e.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            drops.forEach(d -> {
                ItemEntity ent = e.func_70099_a(d, 1.0f);
                if (ent != null) {
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)(RandHelper.getRandomMinusOneToOne(rand) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)(RandHelper.getRandomMinusOneToOne(rand) * 0.1f)));
                }
            });
            player.func_71020_j(0.01f);
        }
    }

    private void spawnBlizzardParticles(Vector3d lookVector, PlayerEntity player) {
        BlockParticleData blockParticleData = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196604_cC.func_176223_P());
        for (int i = 0; i < 16; ++i) {
            float randX = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            float randY = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            float randZ = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            player.field_70170_p.func_195594_a((IParticleData)blockParticleData, player.func_226277_ct_() + (double)randX, player.func_226278_cu_() + (double)randY, player.func_226281_cx_() + (double)randZ, lookVector.field_72450_a * 5.0, lookVector.field_72448_b * 5.0, lookVector.field_72449_c * 5.0);
        }
    }
}

